/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.action;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.BattleMarkData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Static;

public class BattleWidget
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Storage storage = Storage.getInstance();
    private final Model model = Model.getInstance();

    public BattleWidget(final BattleMarkData data) {
        TextureAtlas atlas = this.assets.getCommonAtlas();
        this.defaults().space(6.0f);
        Table nameTable = new Table();
        nameTable.setBackground(this.assets.getNinePatchDrawable(this.assets.getCommonAtlas(), this.getNameBackground(data.avatar1.fractionId), 15, 15, 0, 4));
        Label.LabelStyle nameStyle = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
        Label name = new Label((CharSequence)data.avatar1.getFullName(), nameStyle);
        nameTable.add(name).expand().top();
        this.add(nameTable).width(146.0f).space(6.0f).row();
        this.add(new Image(this.assets.getDrawable(atlas, "element_icon0003"))).expandX().row();
        nameTable = new Table();
        nameTable.setBackground(this.assets.getNinePatchDrawable(this.assets.getCommonAtlas(), this.getNameBackground(data.avatar2.fractionId), 15, 15, 0, 4));
        name = new Label((CharSequence)data.avatar2.getFullName(), nameStyle);
        nameTable.add(name).expand().top();
        this.add(nameTable).width(146.0f).space(6.0f).row();
        Table timeTable = new Table();
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        Label startName = new Label((CharSequence)"\u041d\u0430\u0447\u0430\u043b\u043e: ", style);
        timeTable.add(startName).expandX().left();
        style = new Label.LabelStyle(this.assets.getFont().arial14, Color.valueOf("#EFD774"));
        Label start = new Label((CharSequence)TimeUtils.shortWithoutYear(data.timeStart.getTime()), style);
        timeTable.add(start).expandX().right();
        this.add(timeTable).row();
        AvatarData avatar = this.model.player.selectedAvatar;
        PlanetData planet = this.storage.planet.get(avatar.planetId);
        if (avatar.isAdmin() || this.storage.planet.isHomePlanet(planet) || this.storage.planet.isEris(planet)) {
            TextButton joinBtn = new TextButton("\u0421\u043c\u043e\u0442\u0440\u0435\u0442\u044c", this.assets.getUi().yellowButtonStyle);
            joinBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    Commander.getInstance().BattleActionJoin(data.id);
                }
            });
            this.add(joinBtn).expand().bottom();
        }
    }

    private String getNameBackground(long fractionId) {
        Static.StaticFaction faction = this.storage.faction.get(fractionId);
        if (this.storage.faction.isOseon(faction.getCode())) {
            return "fraction_back0001";
        }
        return "fraction_back0002";
    }
}

