/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.admin;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.admin.PunishmentListWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import packet.Punishment;
import packet.Transport;

public class AdminWindow
extends DefaultWindow
implements MessageListener {
    private TextField inputName;
    private TextField inputReason;
    private TextField inputTime;
    private TextButton actionButton;

    public AdminWindow() {
        super("Admin");
    }

    @Override
    public void openHandler() {
        Table main = new Table();
        main.defaults().space(20.0f);
        this.getContentTable().add(main).expand().padLeft(20.0f).padRight(20.0f).padTop(10.0f).padBottom(10.0f);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                super.keyboardFocusChanged(event, actor, focused);
                if (!focused) {
                    Gdx.input.setOnscreenKeyboardVisible(false);
                }
            }
        };
        TextureAtlas atlas = assets.getCommonAtlas();
        TextField.TextFieldStyle textInputStyle = new TextField.TextFieldStyle();
        textInputStyle.background = assets.getNinePatchDrawable(atlas, "message_text_bg", 4, 4, 2, 2);
        textInputStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        textInputStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
        textInputStyle.font = AdminWindow.assets.getFont().arialBold14;
        textInputStyle.fontColor = Color.WHITE;
        this.inputName = new TextField("", textInputStyle);
        this.inputName.setMessageText("\u0418\u043c\u044f");
        this.inputName.addListener(focusListener);
        main.add(this.inputName).width(200.0f).row();
        TextureAtlas windowAtlas = assets.getWindowAtlas();
        TextButton.TextButtonStyle changeBtnStyle = new TextButton.TextButtonStyle();
        changeBtnStyle.up = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_up", 4, 4, 4, 4);
        changeBtnStyle.over = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_over", 4, 4, 4, 4);
        changeBtnStyle.down = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_disable", 4, 4, 4, 4);
        changeBtnStyle.disabled = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_disable", 4, 4, 4, 4);
        changeBtnStyle.font = AdminWindow.assets.getFont().arialBold14;
        TextButton changeAvatarBtn = new TextButton("\u041d\u0430\u043a\u0430\u0437\u0430\u043d\u0438\u044f", changeBtnStyle);
        changeAvatarBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AdminWindow.this.inputName.getText().length() < 3) {
                    WindowManager.getInstance().open(new WarningWindow(WarningWindow.Type.ERROR, "Error", "Incorrect nickname", "OK"), true);
                    return;
                }
                Commander.getInstance().GetPunishments(AdminWindow.this.inputName.getText());
            }
        });
        main.add(changeAvatarBtn).width(200.0f).row();
        this.inputTime = new TextField("", textInputStyle);
        this.inputTime.setMessageText("\u0412 \u0447\u0430\u0441\u0430\u0445 (1-168)");
        this.inputTime.setTextFieldFilter(new TextField.TextFieldFilter.DigitsOnlyFilter());
        this.inputTime.addListener(focusListener);
        main.add(this.inputTime).width(200.0f).row();
        TextButton.TextButtonStyle leftBtnStyle = new TextButton.TextButtonStyle();
        leftBtnStyle.checked = assets.getNinePatchDrawable(windowAtlas, "red_radio_btn_on", 4, 0, 0, 0);
        leftBtnStyle.up = assets.getNinePatchDrawable(windowAtlas, "red_radio_btn_off", 4, 0, 0, 0);
        leftBtnStyle.font = AdminWindow.assets.getFont().arialBold14;
        leftBtnStyle.fontColor = Color.LIGHT_GRAY;
        leftBtnStyle.checkedFontColor = Color.WHITE;
        Table buttonTable = new Table();
        final TextButton banBtn = new TextButton("\u0411\u0410\u041d", leftBtnStyle);
        banBtn.getLabelCell().padLeft(6.0f);
        buttonTable.add(banBtn).width(90.0f);
        TextButton.TextButtonStyle rightBtnStyle = new TextButton.TextButtonStyle(leftBtnStyle);
        rightBtnStyle.checked = assets.getNinePatchDrawable(windowAtlas, "red_right_radio_btn_on", 0, 4, 0, 0);
        rightBtnStyle.up = assets.getNinePatchDrawable(windowAtlas, "red_right_radio_btn_off", 0, 4, 0, 0);
        TextButton muteBtn = new TextButton("\u041a\u041b\u042f\u041f", rightBtnStyle);
        muteBtn.getLabelCell().padLeft(6.0f);
        buttonTable.add(muteBtn).width(90.0f);
        final ButtonGroup banType = new ButtonGroup((Button[])new TextButton[]{banBtn, muteBtn});
        banType.setMinCheckCount(1);
        banType.setChecked(muteBtn.getText().toString());
        main.add(buttonTable).width(200.0f).expandX().row();
        this.inputReason = new TextArea("", textInputStyle);
        this.inputReason.setMessageText("\u041f\u0440\u0438\u0447\u0438\u043d\u0430");
        this.inputReason.addListener(focusListener);
        main.add(this.inputReason).width(200.0f).height(100.0f);
        this.actionButton = new TextButton("\u041d\u0430\u043a\u0430\u0437\u0430\u0442\u044c", AdminWindow.assets.getUi().yellowButtonStyle);
        this.getButtonTable().add(this.actionButton);
        this.getButtonTable().padBottom(6.0f);
        this.actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (AdminWindow.this.inputTime.getText().length() == 0 || AdminWindow.this.inputName.getText().length() < 3 || AdminWindow.this.inputReason.getText().length() == 0) {
                    WindowManager.getInstance().open(new WarningWindow(WarningWindow.Type.ERROR, "Error", "Incorrect data", "OK"), true);
                    return;
                }
                int code = banType.getChecked() == banBtn ? 1 : 2;
                AdminWindow.this.comander.AvatarPunish(AdminWindow.this.inputName.getText(), AdminWindow.this.inputReason.getText(), Integer.parseInt(AdminWindow.this.inputTime.getText()), code);
                AdminWindow.this.closeHandler();
            }
        });
        this.model.addListener(this, Cmd.PunishmentList.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case PunishmentList: {
                WindowManager.getInstance().open(new PunishmentListWindow(this.inputName.getText(), Punishment.PunishmentList.parseFrom(msg.getData())), true);
                break;
            }
        }
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
        this.model.removeListeners(this);
    }
}

