/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.admin;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import packet.Punishment;

public class PunishmentListWindow
extends DefaultWindow {
    private String name;
    private Table main;
    private Punishment.PunishmentList punishments;

    public PunishmentListWindow(String name, Punishment.PunishmentList punishments) {
        super("");
        this.name = name;
        this.punishments = punishments;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.name);
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).expand().fillX().top().pad(10.0f, 20.0f, 10.0f, 20.0f);
        TextureAtlas atlas = assets.getCommonAtlas();
        Table list = new Table();
        list.defaults().space(6.0f);
        for (final Punishment.PunishmentDto p : this.punishments.getPunishmentsList()) {
            PunishmentLine line = new PunishmentLine(p);
            line.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    boolean canDropPunishment;
                    boolean bl = canDropPunishment = ((PunishmentListWindow)PunishmentListWindow.this).model.player.selectedAvatar.id == p.getModeratorId() && PunishmentListWindow.this.model.getServerTime() < p.getEndTime();
                    if (canDropPunishment) {
                        ClickListener dropPunishment = new ClickListener(){

                            @Override
                            public void clicked(InputEvent event, float x, float y) {
                                Commander.getInstance().DropPunishment(p.getId());
                                PunishmentListWindow.this.closeHandler();
                            }
                        };
                        String text = "[" + PunishmentListWindow.this.name + "]\n\n" + p.getDescription() + "\n\n\u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043d\u044f\u0442\u044c \u043d\u0430\u043a\u0430\u0437\u0430\u043d\u0438\u0435?";
                        WarningWindow wnd = new WarningWindow(WarningWindow.Type.WARNING, "\u041d\u0430\u043a\u0430\u0437\u0430\u043d\u0438\u0435", text, "\u0421\u043d\u044f\u0442\u044c", dropPunishment);
                        WindowManager.getInstance().open(wnd, true);
                    }
                }
            });
            list.add(line).grow().row();
        }
        ScrollPane scrollPane = new ScrollPane((Actor)list);
        Table container = new Table();
        container.setBackground(assets.getNinePatchDrawable(atlas, "message_text_bg", 6, 6, 4, 4));
        container.add(scrollPane).growX().expandY().top();
        this.main.add(container).colspan(2).height(360.0f).grow();
    }

    class PunishmentLine
    extends Table {
        public PunishmentLine(Punishment.PunishmentDto p) {
            this.defaults().space(6.0f);
            TextureAtlas atlas = assets.getCommonAtlas();
            this.setBackground(assets.getDrawable(atlas, "clan_line_bg"));
            this.padLeft(6.0f).padRight(6.0f).padTop(4.0f).padBottom(4.0f);
            Color color = p.getCode() == 1 ? Color.CORAL : Color.SKY;
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, color);
            Label desc = new Label((CharSequence)p.getDescription(), style);
            desc.setWrap(true);
            this.add(desc).width(400.0f).growY().left();
            style = new Label.LabelStyle(style);
            boolean canDropPunishment = ((PunishmentListWindow)PunishmentListWindow.this).model.player.selectedAvatar.id == p.getModeratorId() && PunishmentListWindow.this.model.getServerTime() < p.getEndTime();
            style.fontColor = canDropPunishment ? Color.GREEN : Color.WHITE;
            Label date = new Label((CharSequence)(TimeUtils.convertTime(p.getStartTime()) + "\n" + TimeUtils.convertTime(p.getEndTime())), style);
            this.add(date).left().expand();
        }

        public void removeFromParentCell() {
            Table table = (Table)this.getParent();
            Cell<PunishmentLine> cell = table.getCell(this);
            table.getCells().removeValue(cell, true);
            cell.clearActor();
        }
    }
}

