/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.arena;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectSet;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.Storage;
import com.tpwar.storage.avatar.ArtefactType;
import com.tpwar.storage.planet.PlanetData;
import java.util.LinkedList;
import packet.Arena;
import packet.Avatars;
import packet.Base;
import packet.Battle;
import packet.Static;
import packet.Transport;

public class ArenaWindow
extends DefaultWindow
implements MessageListener {
    private Table header;
    private Table battles;
    private Table modes;
    private Table main;
    private TextButton startBtn;
    private Label status;
    private Label timer;
    private boolean search = false;
    private float timerDelta = 0.0f;
    private long timeLeft = 0L;
    private LinkedList<ArenaBattleLine> arenaBattleList = new LinkedList();
    private Table statusTable;

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.arena"));
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).expand().fillX().top().pad(10.0f, 10.0f, 10.0f, 10.0f);
        this.battles = new Table();
        this.battles.defaults().space(6.0f);
        ScrollPane scrollPane = new ScrollPane((Actor)this.battles);
        Table container = new Table();
        container.setBackground(assets.getNinePatchDrawable(assets.getWindowAtlas(), "content_background", 6, 6, 6, 6));
        container.add(scrollPane).growX().expandY().top();
        this.modes = this.modes();
        this.main.add(container).size(380.0f, 280.0f).padBottom(0.0f);
        this.main.add(this.modes).grow().padTop(0.0f).padBottom(0.0f);
        this.model.addListener(this, Cmd.ArenaBattleList.getCode());
        this.model.addListener(this, Cmd.StartArenaBattle.getCode());
        this.model.addListener(this, Cmd.Error.getCode());
        this.comander.GetArenaBattles();
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }

    private Table modes() {
        Table result = new Table();
        result.defaults().space(10.0f);
        TextureAtlas atlas = assets.getCommonAtlas();
        TextButton.TextButtonStyle btnStyle = new TextButton.TextButtonStyle();
        btnStyle.checked = assets.getNinePatchDrawable(atlas, "max_btn_down", 6, 6, 1, 1);
        btnStyle.up = assets.getNinePatchDrawable(atlas, "max_btn_up", 6, 6, 1, 1);
        btnStyle.disabled = assets.getNinePatchDrawable(atlas, "max_btn_disable", 6, 6, 1, 1);
        btnStyle.font = ArenaWindow.assets.getFont().centryGothicBold14;
        btnStyle.fontColor = Color.valueOf("#EFD774");
        btnStyle.disabledFontColor = Color.DARK_GRAY;
        this.statusTable = new Table();
        this.startBtn = new TextButton(this.model.lang.get("window.arena.battle_btn"), btnStyle);
        this.startBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (((ArenaWindow)ArenaWindow.this).model.player.selectedAvatar.getNumCreatedUnits() == 0) {
                    WindowManager.getInstance().open(WarningWindow.create(WarningWindow.Type.INFO, "window.arena", "window.arena.require_full_army", "window.confirm.ok"), true);
                    return;
                }
                if (!ArenaWindow.this.search) {
                    PlanetData planet = ((ArenaWindow)ArenaWindow.this).storage.planet.getRandomAvailPlanet(((ArenaWindow)ArenaWindow.this).model.player.selectedAvatar);
                    Static.StaticZone zone = ((ArenaWindow)ArenaWindow.this).storage.zone.getRandomZome(planet);
                    ArenaWindow.this.comander.StartArenaBattle(planet.id, zone.getId(), 0);
                    ArenaWindow.this.timeLeft = 30L;
                } else {
                    ArenaWindow.this.comander.RemoveArenaBattle();
                }
                ArenaWindow.this.search = !ArenaWindow.this.search;
                ArenaWindow.this.updateStatus();
            }
        });
        Label.LabelStyle style = new Label.LabelStyle(ArenaWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        this.status = new Label((CharSequence)this.model.lang.get("window.arena.start"), style);
        this.timer = new Label((CharSequence)this.model.lang.get("window.arena.until_start"), style);
        this.timer.setAlignment(8);
        this.statusTable.add(this.status).expandX();
        this.getButtonTable().add(this.statusTable).growX().pad(6.0f);
        style = new Label.LabelStyle(ArenaWindow.assets.getFont().arial14, Color.valueOf("#EFD774"));
        Label rewardText = new Label((CharSequence)"\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435\n\u043d\u0430\u0433\u0440\u0430\u0434\u044b:", style);
        rewardText.setWrap(true);
        result.add(rewardText).width(100.0f).left().row();
        Array<Actor> items = this.constructAvailRewardItems();
        Table rewardTable = new Table();
        rewardTable.setBackground(assets.getNinePatchDrawable(atlas, "win_bg", 6, 6, 6, 6));
        for (int i = 0; i < items.size; ++i) {
            Cell<Actor> cell = rewardTable.add(items.get(i)).space(6.0f);
            if ((i + 1) % 2 != 0) continue;
            cell.row();
        }
        result.add(rewardTable).row();
        result.add(this.startBtn).expand().right().bottom();
        return result;
    }

    private Array<Actor> constructAvailRewardItems() {
        TextureAtlas commonAtlas = assets.getCommonAtlas();
        TextureAtlas profileAtlas = (TextureAtlas)assets.get("ui/profile.atlas");
        Label.LabelStyle style = new Label.LabelStyle(ArenaWindow.assets.getFont().arial14, Color.valueOf("EFD774"));
        Array<Actor> items = new Array<Actor>();
        Stack stack = new Stack();
        stack.add(new Image(profileAtlas.findRegion("slot")));
        stack.add(new Container<Image>(new Image(commonAtlas.findRegion("energy_icon"))));
        Table energy = new Table();
        energy.add(stack).row();
        items.add(energy);
        ObjectSet<String> addedTypes = new ObjectSet<String>(4);
        for (ArtefactType artefactType : this.storage.artefactType.getAll()) {
            if (addedTypes.contains(artefactType.code)) continue;
            String iconName = "dead_ray_icon";
            switch (artefactType.code) {
                case "double_power": {
                    iconName = "double_power_icon";
                    break;
                }
                case "dynamic_shield": {
                    iconName = "dynamic_shield_icon";
                    break;
                }
                case "heal": {
                    iconName = "heal_icon";
                }
            }
            addedTypes.add(artefactType.code);
            Table artefact = new Table();
            artefact.add(new Image(profileAtlas.findRegion(iconName))).row();
            items.add(artefact);
        }
        return items;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.search) {
            this.timerDelta += delta;
            if (this.timerDelta > 1.0f) {
                this.timerDelta -= 1.0f;
                this.updateTimer();
            }
        }
    }

    private void updateTimer() {
        if (this.timeLeft == 0L) {
            this.search = false;
        }
        this.timer.setText(this.model.lang.get("window.arena.until_start") + " " + this.timeLeft--);
    }

    private void updateStatus() {
        if (this.search) {
            this.status.setText(this.model.lang.get("window.arena.search"));
            this.startBtn.setText(this.model.lang.get("window.arena.stop_btn"));
            this.statusTable.clear();
            this.statusTable.add(this.status).expandX().left();
            this.statusTable.add(this.timer).minWidth(125.0f).left();
            this.updateTimer();
        } else {
            this.startBtn.setText(this.model.lang.get("window.arena.battle_btn"));
            this.status.setText(this.model.lang.get("window.arena.start"));
            this.statusTable.clear();
            this.statusTable.add(this.status).expandX();
        }
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case ArenaBattleList: {
                this.arenaBattleList.clear();
                Arena.ArenaBattles arenaBattles = Arena.ArenaBattles.parseFrom(msg.getData());
                AvatarData avatar = this.model.player.selectedAvatar;
                for (Arena.ArenaBattleDto ab : arenaBattles.getArenaBattlesList()) {
                    if (!this.search) {
                        for (Avatars.AvatarDto a : ab.getAvatarsList()) {
                            if (a.getId() != avatar.id) continue;
                            this.search = true;
                            this.timeLeft = this.getLeftTime(ab);
                            break;
                        }
                    }
                    ArenaBattleLine battleLine = new ArenaBattleLine(ab);
                    this.arenaBattleList.add(battleLine);
                }
                break;
            }
            case StartArenaBattle: {
                Arena.ArenaBattleDto ab = Arena.ArenaBattleDto.parseFrom(msg.getData());
                this.timeLeft = this.getLeftTime(ab);
                ArenaBattleLine battleLine = new ArenaBattleLine(ab);
                this.arenaBattleList.addFirst(battleLine);
                break;
            }
            case Error: {
                Base.ErrorMsg errorMsg = Base.ErrorMsg.parseFrom(msg.getData());
                if (errorMsg.getCode() != 410) break;
                WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.arena", "window.arena.require_full_army", "window.confirm.ok");
                WindowManager.getInstance().open(wnd, true);
                return;
            }
        }
        this.battles.clear();
        for (final ArenaBattleLine battleLine : this.arenaBattleList) {
            battleLine.setTouchable(Touchable.enabled);
            battleLine.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (battleLine.ab.getStarted() && battleLine.ab.getBattlesCount() > 0) {
                        Battle.BattleDto battleDto = battleLine.ab.getBattles(0);
                        ArenaWindow.this.comander.BattleActionJoin(battleDto.getId());
                    }
                }
            });
            this.battles.add(battleLine).growX().row();
        }
        this.updateStatus();
    }

    private long getLeftTime(Arena.ArenaBattleDto ab) {
        return 30L - (this.model.getServerTime() - ab.getCreated()) / 1000L;
    }

    class ArenaBattleLine
    extends Table {
        public Arena.ArenaBattleDto ab;

        public ArenaBattleLine(Arena.ArenaBattleDto ab) {
            this.ab = ab;
            TextureAtlas atlas = assets.getCommonAtlas();
            Storage storage = Storage.getInstance();
            Table header = new Table();
            header.setBackground(assets.getNinePatchDrawable(atlas, "exchanger_pos", 0, 0, 0, 0));
            header.defaults().padLeft(6.0f).padRight(6.0f);
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arial14, Color.valueOf("#F0E9CF"));
            Label mode = new Label((CharSequence)(((ArenaWindow)ArenaWindow.this).model.lang.get("window.arena.mode") + " 1vs1"), style);
            Label planet = new Label((CharSequence)(((ArenaWindow)ArenaWindow.this).model.lang.get("window.arena.planet") + " " + storage.planet.get((long)ab.getPlanetId()).name), style);
            header.add(mode).expandX().left();
            header.add(planet).expandX().right();
            Table main = new Table();
            main.defaults().space(6.0f);
            main.setBackground(assets.getNinePatchDrawable(atlas, "clan_line_bg", 4, 4, 4, 4));
            main.padLeft(6.0f).padRight(6.0f);
            int modeSize = 2;
            Label.LabelStyle vsStyle = new Label.LabelStyle(assets.getFont().centryGothicBold14, Color.valueOf("#F0E9CF"));
            for (int i = 0; i < modeSize; ++i) {
                if (ab.getAvatarsList().size() > i) {
                    Avatars.AvatarDto avatar = ab.getAvatarsList().get(i);
                    Table avatarTable = new Table();
                    String iconName = avatar.getFractionId() == 1L ? "std_oseon_icon" : "std_wayland_icon";
                    Image icon = new Image(atlas.findRegion(iconName));
                    avatarTable.add(icon).size(42.0f).pad(2.0f).row();
                    String color = storage.faction.getColor(avatar.getFractionId());
                    style = avatar.getName().equals("Dark Illusion") ? new Label.LabelStyle(assets.getFont().arial12, Color.LIGHT_GRAY) : new Label.LabelStyle(assets.getFont().arial12, Color.valueOf(color));
                    String text = String.format("%s[%d]", avatar.getName(), avatar.getLevel());
                    Label name = new Label((CharSequence)text, style);
                    name.setEllipsis(true);
                    avatarTable.add(name);
                    main.add(avatarTable);
                } else {
                    Table avatarTable = new Table();
                    Image icon = new Image(atlas.findRegion("std_oseon_icon"));
                    icon.setColor(Color.BLACK);
                    avatarTable.add(icon).size(42.0f).pad(2.0f).row();
                    style = new Label.LabelStyle(assets.getFont().arial12, Color.WHITE);
                    Label name = new Label((CharSequence)((ArenaWindow)ArenaWindow.this).model.lang.get("window.arena.waiting"), style);
                    name.setEllipsis(true);
                    avatarTable.add(name);
                    main.add(avatarTable).expandY().top();
                }
                if (i >= modeSize - 1) continue;
                Label vs = new Label((CharSequence)"VS", vsStyle);
                main.add(vs);
            }
            this.add(header).growX().row();
            this.add(main).growX();
        }
    }
}

