/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.bank;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.pay.Information;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import packet.Static;

public class BankPositionWidget
extends Group {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private Image backImage;

    public BankPositionWidget(Static.StaticBankPosition data, Information info) {
        TextureAtlas atlas = this.assets.getCommonAtlas();
        this.backImage = new Image(atlas.findRegion("bank_position_bg"));
        this.addActor(this.backImage);
        Image crystal = new Image(atlas.findRegion("bank_crystal"));
        crystal.setX((this.backImage.getWidth() - crystal.getWidth()) / 2.0f);
        crystal.setY(this.backImage.getHeight() - crystal.getHeight());
        this.addActor(crystal);
        Table crystalTable = new Table();
        crystalTable.defaults().space(6.0f);
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold16, Color.valueOf("#B5FFFF"));
        Label num = new Label((CharSequence)String.valueOf(data.getCrystals()), style);
        crystalTable.add(num).left().expandX();
        style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#00A1FB"));
        Label crystalText = new Label((CharSequence)this.model.lang.get("window.bank.crystals"), style);
        crystalTable.add(crystalText).right().expandX();
        crystalTable.pack();
        crystalTable.setPosition((this.backImage.getWidth() - crystalTable.getWidth()) / 2.0f, 46.0f);
        this.addActor(crystalTable);
        if (data.getExtraCrystals() > 0) {
            style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#FEF787"));
            Label bonus = new Label((CharSequence)("+" + data.getExtraCrystals() + " " + this.model.lang.get("window.bank.bonus")), style);
            bonus.setPosition(this.backImage.getWidth() - bonus.getWidth() - 14.0f, 31.0f);
            this.addActor(bonus);
        }
        style = new Label.LabelStyle(this.assets.getFont().arialBold16, Color.WHITE);
        Object priceText = this.model.lang.get("window.bank.buy");
        if (info != null) {
            priceText = info.getLocalPricing() + " " + this.model.lang.get("window.bank.buy");
        }
        Label buy = new Label((CharSequence)priceText, style);
        buy.setPosition((this.backImage.getWidth() - buy.getWidth()) / 2.0f, 3.0f);
        this.addActor(buy);
        this.setSize(this.backImage.getWidth(), this.backImage.getHeight());
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                BankPositionWidget.this.clearActions();
                BankPositionWidget.this.addAction(Actions.alpha(0.8f, 0.3f, Interpolation.pow4Out));
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                BankPositionWidget.this.clearActions();
                BankPositionWidget.this.addAction(Actions.alpha(1.0f, 0.3f, Interpolation.pow4Out));
                super.touchUp(event, x, y, pointer, button);
            }
        });
    }

    public void best() {
        TextureAtlas atlas = this.assets.getCommonAtlas();
        Image best = new Image(atlas.findRegion("bank_position_best"));
        best.setY(this.backImage.getHeight() - best.getHeight() + 2.0f);
        best.setX(-2.0f);
        this.addActor(best);
    }
}

