/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.bank;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.pay.Information;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.ScaleScreen;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.bank.BankPositionWidget;
import com.tpwar.payment.Billing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import packet.Static;

public class BankWindow
extends DefaultWindow {
    private Billing billing = Billing.getInstance();

    public BankWindow() {
        super("");
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.bank"));
        Table main = new Table();
        main.defaults().space(20.0f);
        this.getContentTable().add(main).expand().padLeft(20.0f).padRight(20.0f).padTop(10.0f).padBottom(10.0f);
        List<Static.StaticBankPosition> positions = this.storage.bank.getAll();
        positions = new ArrayList<Static.StaticBankPosition>(positions);
        Collections.sort(positions, new Comparator<Static.StaticBankPosition>(){

            @Override
            public int compare(Static.StaticBankPosition t0, Static.StaticBankPosition t1) {
                if (t0.getPrice() < t1.getPrice()) {
                    return -1;
                }
                if (t0.getPrice() > t1.getPrice()) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < positions.size(); ++i) {
            final Static.StaticBankPosition sbp = positions.get(i);
            Information information = this.billing.getManager().getInformation(sbp.getItemId());
            BankPositionWidget positionWidget = new BankPositionWidget(sbp, information);
            positionWidget.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (ScaleScreen.isDesktop()) {
                        Model model = Model.getInstance();
                        Object link = "https://tpwar.ru/bank.html";
                        if (!model.player.avatars.isEmpty()) {
                            link = (String)link + "?name=" + model.player.avatars.get((int)0).name;
                        }
                        Gdx.net.openURI((String)link);
                    } else {
                        BankWindow.this.billing.getManager().purchase(sbp.getItemId());
                    }
                }
            });
            main.add(positionWidget);
            if (i == 2) {
                main.row();
            }
            if (i != 3) continue;
            positionWidget.best();
        }
    }
}

