/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.barrack;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;

class BarrackResetBlock
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/common.atlas");
    private Label availPoints;
    private Label usedPoints;
    TextButton resetPointBtn;

    public BarrackResetBlock() {
        this.setBackground(this.assets.getNinePatchDrawable(this.atlas, "element_back", 5, 5, 5, 5));
        this.defaults().space(6.0f).padLeft(10.0f);
        Label.LabelStyle labelStyle = new Label.LabelStyle();
        labelStyle.font = this.assets.getFont().arialBold14;
        labelStyle.fontColor = Color.valueOf("#EFD774");
        Label blockName = new Label((CharSequence)this.model.lang.get("window.barrack.points"), labelStyle);
        this.add(blockName).expand().top().left().row();
        Label.LabelStyle textLabelStyle = new Label.LabelStyle();
        textLabelStyle.font = this.assets.getFont().arial14;
        textLabelStyle.fontColor = Color.valueOf("#F0E9CF");
        this.availPoints = new Label((CharSequence)this.model.lang.get("window.barrack.points.avail"), textLabelStyle);
        this.add(this.availPoints).expandX().left().row();
        this.usedPoints = new Label((CharSequence)this.model.lang.get("window.barrack.points.used"), textLabelStyle);
        this.add(this.usedPoints).expandX().left().row();
        this.resetPointBtn = new TextButton(this.model.lang.get("window.barrack.points.reset"), this.assets.getUi().buyButtonStyle);
        this.add(this.resetPointBtn).expand();
    }

    public void update(int avail, int used) {
        this.availPoints.setText(this.model.lang.get("window.barrack.points.avail") + avail);
        this.usedPoints.setText(this.model.lang.get("window.barrack.points.used") + used + "/15");
    }
}

