/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.barrack;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.TimeWarpData;
import com.tpwar.domain.avatar.UnitData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.domain.avatar.UnitUpgradeData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.managers.UnitManager;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.barrack.BarrackResetBlock;
import com.tpwar.game.windows.barrack.UnitParameterLine;
import com.tpwar.game.windows.barrack.UnitSlot;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.unit.UnitTypeData;
import packet.Static;
import packet.Transport;

public class BarrackWindow
extends DefaultWindow
implements MessageListener {
    private final WindowManager windowManager = WindowManager.getInstance();
    private TextureAtlas barrackWndAtlas = (TextureAtlas)assets.get("ui/barrack.atlas");
    private TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
    private Storage storage = Storage.getInstance();
    private Model model = Model.getInstance();
    private Commander commander = Commander.getInstance();
    private UnitParameterLine uplDamage;
    private UnitParameterLine uplArmor;
    private UnitParameterLine uplHealth;
    private Label hourglasText;
    private Label parametersName;
    private BarrackResetBlock barrackResetBlock;
    private Array<UnitSlot> slots = new Array(3);
    private UnitTypeData currentUnitType;
    private AvatarData avatar;
    private TimeWarpData timeWarpData;
    private float timeState = 0.0f;
    private TextButton buyUnits;

    public BarrackWindow() {
        super(625, 460);
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.barrack"));
        this.avatar = this.model.player.selectedAvatar;
        this.timeWarpData = this.avatar.getActiveTimeWarp();
        float stepX = this.getWidth() / 3.0f;
        float offsetX = -50.0f;
        for (UnitTypeData utd : this.storage.unitType.getAll()) {
            final UnitSlot unitSlot = new UnitSlot(utd);
            unitSlot.setX(offsetX + (stepX - unitSlot.getWidth()) / 2.0f);
            unitSlot.setY(this.getHeight() - 220.0f);
            unitSlot.setInactive();
            unitSlot.hideTimer();
            this.slots.add(unitSlot);
            unitSlot.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (unitSlot.getUnitTypeData() == BarrackWindow.this.currentUnitType) {
                        return;
                    }
                    if (unitSlot.isEnable()) {
                        BarrackWindow.this.setUnit(unitSlot);
                        BarrackWindow.this.unitChange(unitSlot);
                    }
                }
            });
            this.addActor(unitSlot);
            offsetX += stepX;
        }
        for (int i = 1; i <= 2; ++i) {
            Image separator = Component.getImage(this.barrackWndAtlas, "unit_slot_sep");
            separator.setX(stepX * (float)i);
            separator.setY(this.getHeight() - 180.0f);
            this.addActor(separator);
        }
        Group parameters = new Group();
        parameters.setY(110.0f);
        parameters.setX(35.0f);
        Label.LabelStyle labelStyle = new Label.LabelStyle();
        labelStyle.font = BarrackWindow.assets.getFont().arialBold14;
        labelStyle.fontColor = Color.valueOf("#EFD774");
        this.parametersName = new Label((CharSequence)this.model.lang.format("window.barrack.unit_parameters", ""), labelStyle);
        this.parametersName.setY(90.0f);
        parameters.addActor(this.parametersName);
        this.uplDamage = new UnitParameterLine("damage_icon", this.model.lang.get("window.barrack.damage"));
        this.uplDamage.setY(60.0f);
        this.uplDamage.btnUp.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                BarrackWindow.this.commander.UnitActionUpgrade(BarrackWindow.this.currentUnitType.id, true, false, false);
                ((BarrackWindow)BarrackWindow.this).soundSystem.fx.play("sound/fx/27. Set_slot.mp3");
            }
        });
        parameters.addActor(this.uplDamage);
        this.uplArmor = new UnitParameterLine("armor_icon", this.model.lang.get("window.barrack.armor"));
        this.uplArmor.setY(30.0f);
        this.uplArmor.btnUp.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                BarrackWindow.this.commander.UnitActionUpgrade(BarrackWindow.this.currentUnitType.id, false, true, false);
                ((BarrackWindow)BarrackWindow.this).soundSystem.fx.play("sound/fx/27. Set_slot.mp3");
            }
        });
        parameters.addActor(this.uplArmor);
        this.uplHealth = new UnitParameterLine("health_icon", this.model.lang.get("window.barrack.health"));
        this.uplHealth.setY(0.0f);
        this.uplHealth.btnUp.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                BarrackWindow.this.commander.UnitActionUpgrade(BarrackWindow.this.currentUnitType.id, false, false, true);
                ((BarrackWindow)BarrackWindow.this).soundSystem.fx.play("sound/fx/27. Set_slot.mp3");
            }
        });
        parameters.addActor(this.uplHealth);
        Label.LabelStyle hourglassLabelStyle = new Label.LabelStyle();
        hourglassLabelStyle.font = BarrackWindow.assets.getFont().arialBold14;
        hourglassLabelStyle.fontColor = Color.valueOf("#F0E9CF");
        Image hourglass = Component.getImage(this.barrackWndAtlas, "hourglass_icon");
        hourglass.setY(-30.0f);
        parameters.addActor(hourglass);
        this.hourglasText = new Label((CharSequence)this.model.lang.get("window.barrack.recovery_time"), hourglassLabelStyle);
        this.hourglasText.setY(-30.0f);
        this.hourglasText.setX(20.0f);
        parameters.addActor(this.hourglasText);
        Image paramsBack = Component.getImage(this.atlas, "element_back", 5, 5, 5, 5);
        paramsBack.setX(15.0f);
        paramsBack.setY(60.0f);
        paramsBack.setWidth(370.0f);
        paramsBack.setHeight(168.0f);
        this.addActor(paramsBack);
        this.addActor(parameters);
        this.barrackResetBlock = new BarrackResetBlock();
        this.barrackResetBlock.setX(400.0f);
        this.barrackResetBlock.setY(60.0f);
        this.barrackResetBlock.setSize(208.0f, 168.0f);
        this.addActor(this.barrackResetBlock);
        this.barrackResetBlock.resetPointBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                FinanceManager.showConfirmWindow(BarrackWindow.this.model.lang.format("window.confirm.reset_points.message", 125), new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        if (FinanceManager.checkCrystals(BarrackWindow.this.model.player, 125)) {
                            BarrackWindow.this.comander.UnitActionRemoveUpgrades(BarrackWindow.this.avatar.id);
                            BarrackWindow.this.windowManager.closeCurrentWindow();
                            BarrackWindow.this.closeHandler();
                        }
                    }
                });
            }
        });
        this.buyUnits = new TextButton(this.model.lang.get("window.barrack.buy_now"), BarrackWindow.assets.getUi().buyButtonStyle);
        this.buyUnits.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                UnitManager.buyUnits();
            }
        });
        this.buyUnits.getLabel().setTouchable(Touchable.disabled);
        this.getButtonTable().add(this.buyUnits);
        this.getButtonTable().padBottom(6.0f);
        this.setUnit(this.slots.get(0));
        this.model.addListener(this, Cmd.UpdateUnits.getCode());
        this.model.addListener(this, Cmd.AvatarUpdate.getCode());
        this.model.addListener(this, Cmd.UnitUpgradeList.getCode());
        this.updateTimer();
        this.buyUnits.setDisabled(this.avatar.getNumUnits() >= 3);
    }

    private void unitChange(UnitSlot unitSlot) {
        this.fire(new ChangeUnitSlotListener.ChangeUnitSlotEvent());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case UpdateUnits: 
            case AvatarUpdate: 
            case UnitUpgradeList: {
                this.update();
                break;
            }
        }
    }

    @Override
    public void act(float delta) {
        this.timeState += delta;
        if (this.timeState >= 1.0f) {
            this.timeState = 0.0f;
            this.updateTimer();
        }
        super.act(delta);
    }

    private void updateTimer() {
        long unitInProcess = 0L;
        long lastTime = 0L;
        for (int i = 0; i < 3; ++i) {
            Array<UnitData> aUnits = this.avatar.units;
            if (aUnits.size == 0) {
                return;
            }
            UnitSlot slot = this.slots.get(i);
            int time = 0;
            for (UnitData unit : aUnits) {
                long timeout;
                boolean applyScale;
                long unitStartTimeMillis = unit.startTime;
                long activationTimeMillis = this.timeWarpData != null ? this.timeWarpData.activationTime : Long.MAX_VALUE;
                boolean bl = applyScale = Math.max(lastTime, unitStartTimeMillis) >= activationTimeMillis;
                long l = applyScale ? (long)unit.getType().getTimeoutWithScale(this.timeWarpData != null ? this.timeWarpData.getType().getSacle() : 0).intValue() : (timeout = (long)unit.getType().timeout);
                if (!unit.isCreated && unitInProcess == 0L) {
                    unitInProcess = unit.id;
                }
                if (unit.unitTypeId != slot.getUnitTypeData().id || unit.isCreated) continue;
                if (unitInProcess != unit.id) {
                    time = (int)((long)time + timeout * 1000L);
                    continue;
                }
                long leftTime = unit.getLeftTime(timeout);
                if (leftTime > 0L) {
                    time = (int)((long)time + leftTime);
                }
                lastTime = unitStartTimeMillis + timeout * 1000L;
            }
            if (time > 0) {
                slot.updateTimer(TimeUtils.convertShortTime(time / 1000));
                unitInProcess = 0L;
                continue;
            }
            slot.hideTimer();
        }
    }

    private void update() {
        this.avatar.checkTimeUnits();
        this.updateParams(this.currentUnitType);
        for (UnitSlot slot : this.slots) {
            slot.update();
        }
        this.updateTimer();
        this.buyUnits.setDisabled(this.avatar.getNumUnits() >= 3);
    }

    private void setUnit(UnitSlot slot) {
        for (UnitSlot s : this.slots) {
            s.update();
            if (s.getUnitTypeData().id != slot.getUnitTypeData().id) {
                s.setInactive();
                continue;
            }
            s.setActive();
        }
        this.updateParams(slot.getUnitTypeData());
    }

    private void updateParams(UnitTypeData unitTypeData) {
        boolean healthUpgradeAvail;
        this.currentUnitType = unitTypeData;
        this.parametersName.setText(this.model.lang.format("window.barrack.unit_parameters", unitTypeData.name));
        int techDamage = 0;
        int techArmor = 0;
        int techHealth = 0;
        for (UnitTechData techData : this.avatar.unitTechs) {
            Static.StaticUnitTech techType = this.storage.techType.get(techData.unitTechTypeId);
            if (techType.getUnitTypeId() != 0L && techType.getUnitTypeId() != unitTypeData.id) continue;
            if (techType.getDamage() > 0) {
                techDamage = techType.getDamage();
            }
            if (techType.getArmor() > 0) {
                techArmor = techType.getArmor();
            }
            if (techType.getHealth() <= 0) continue;
            techHealth = techType.getHealth();
        }
        int damagePoints = 0;
        int armorPoints = 0;
        int healthPoints = 0;
        for (UnitUpgradeData uud : this.avatar.upgrades) {
            if (uud.unitTypeId != unitTypeData.id) continue;
            damagePoints += uud.damage;
            armorPoints += uud.armor;
            healthPoints += uud.health;
        }
        this.uplDamage.updateParameters(unitTypeData.damage, techDamage, damagePoints);
        this.uplArmor.updateParameters(unitTypeData.armor, techArmor, armorPoints);
        this.uplHealth.updateParameters(unitTypeData.health, techHealth, healthPoints);
        int timeout = unitTypeData.getTimeoutWithScale(0);
        if (this.timeWarpData != null) {
            timeout = unitTypeData.getTimeoutWithScale(this.timeWarpData.getType().getSacle());
        }
        this.hourglasText.setText(this.model.lang.get("window.barrack.recovery_time") + TimeUtils.convertShortMinutes(timeout));
        boolean damageUpgradeAvail = damagePoints < 5;
        boolean armorUpgradeAvail = armorPoints < 5;
        boolean bl = healthUpgradeAvail = healthPoints < 5;
        if (this.avatar.upgradePoints > 0 && this.avatar.level >= unitTypeData.minLevel) {
            UnitUpgradeData upgrade = this.avatar.getUpgradeByUnitType(unitTypeData.id);
            if (this.avatar.pointReset) {
                int unitTypeLevel = unitTypeData.minLevel > 0 ? unitTypeData.minLevel - 1 : 0;
                int maxPoints = this.avatar.level - (unitTypeLevel > 0 ? unitTypeLevel : 1);
                this.uplDamage.btnUp.setDisabled(damagePoints >= maxPoints || !damageUpgradeAvail);
                this.uplArmor.btnUp.setDisabled(armorPoints >= maxPoints || !armorUpgradeAvail);
                this.uplHealth.btnUp.setDisabled(healthPoints >= maxPoints || !healthUpgradeAvail);
            } else if (upgrade != null) {
                this.uplDamage.btnUp.setDisabled(upgrade.damage != 0 || !damageUpgradeAvail);
                this.uplArmor.btnUp.setDisabled(upgrade.armor != 0 || !armorUpgradeAvail);
                this.uplHealth.btnUp.setDisabled(upgrade.health != 0 || !healthUpgradeAvail);
            } else {
                this.uplDamage.btnUp.setDisabled(!damageUpgradeAvail);
                this.uplArmor.btnUp.setDisabled(!armorUpgradeAvail);
                this.uplHealth.btnUp.setDisabled(!healthUpgradeAvail);
            }
        } else {
            this.uplDamage.btnUp.setDisabled(true);
            this.uplArmor.btnUp.setDisabled(true);
            this.uplHealth.btnUp.setDisabled(true);
        }
        int used = damagePoints + armorPoints + healthPoints;
        int avail = this.avatar.upgradePoints;
        this.barrackResetBlock.update(avail, used);
    }

    public UnitSlot getUnitSlotByType(long typeId) {
        for (UnitSlot slot : this.slots) {
            if (slot.getUnitTypeData().id != typeId) continue;
            return slot;
        }
        return null;
    }

    public UnitTypeData getCurrentUnitType() {
        return this.currentUnitType;
    }

    public ImageButton getCloseButton() {
        return this.closeButton;
    }

    public TextButton getBuyButton() {
        return this.buyUnits;
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }

    public static abstract class ChangeUnitSlotListener
    implements EventListener {
        @Override
        public boolean handle(Event event) {
            if (!(event instanceof ChangeUnitSlotEvent)) {
                return false;
            }
            this.changed((ChangeUnitSlotEvent)event, event.getTarget());
            return false;
        }

        public abstract void changed(ChangeUnitSlotEvent var1, Actor var2);

        public static class ChangeUnitSlotEvent
        extends Event {
        }
    }
}

