/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.barrack;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.utils.Array;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;

class UnitParameterLine
extends Group {
    private Assets assets = Assets.getInstance();
    private TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/barrack.atlas");
    public ImageButton btnUp;
    private Array<Image> parameters;
    private Label label;
    private String text;

    public UnitParameterLine(String iconName, String text) {
        this.text = text;
        Label.LabelStyle labelStyle = new Label.LabelStyle();
        labelStyle.font = this.assets.getFont().arial14;
        labelStyle.fontColor = Color.valueOf("#F0E9CF");
        Image parameterIcon = Component.getImage(this.atlas, iconName);
        this.addActor(parameterIcon);
        this.label = new Label((CharSequence)text, labelStyle);
        this.label.setX(30.0f);
        this.label.setY(10.0f);
        this.addActor(this.label);
        this.btnUp = Component.getImageButton(this.atlas, "btn_up");
        this.btnUp.setX(314.0f);
        this.addActor(this.btnUp);
        this.parameters = new Array();
    }

    public void updateParameters(int base, int tech, int upgradePoints) {
        int value = base + tech + upgradePoints;
        this.label.setText(this.text + value);
        this.clearParameters();
        this.addParameters(base, "red_line_params");
        this.addParameters(tech, "yellow_line_params");
        this.addParameters(upgradePoints, "green_line_params");
        this.addParameters(25 - value, "empty_line_parameter");
        this.displayParameters();
    }

    private void addParameters(int value, String lineName) {
        for (int i = 0; i < value; ++i) {
            Image lineParams = Component.getImage(this.atlas, lineName);
            this.parameters.add(lineParams);
        }
    }

    private void displayParameters() {
        int offsetX = 30;
        int stepX = 11;
        for (Image lineParams : this.parameters) {
            lineParams.setX(offsetX);
            this.addActor(lineParams);
            offsetX += stepX;
        }
    }

    private void clearParameters() {
        for (Image lineParams : this.parameters) {
            this.removeActor(lineParams);
        }
        this.parameters.clear();
    }
}

