/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.barrack;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.net.Commander;
import com.tpwar.storage.unit.UnitTypeData;

public class UnitSlot
extends Group {
    private Assets assets = Assets.getInstance();
    private Model model = Model.getInstance();
    private TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/barrack.atlas");
    private UnitTypeData unitTypeData;
    private Image slotFade;
    private Label nameUnit;
    private Image unitPlace;
    private Image unitIcon;
    private Image unitIcon2;
    private Label timer;
    private Label numUnitsText;
    private Label lockText;
    private TextButton createBtn;
    private boolean enable;

    public UnitSlot(final UnitTypeData unitTypeData) {
        this.unitTypeData = unitTypeData;
        Label.LabelStyle labelStyle = new Label.LabelStyle();
        labelStyle.font = this.assets.getFont().arialBold16;
        labelStyle.fontColor = Color.valueOf("#EFD774");
        this.unitPlace = Component.getImage(this.atlas, "unit_place");
        this.unitPlace.setX(0.0f);
        this.unitPlace.setY(36.0f);
        this.addActor(this.unitPlace);
        this.unitIcon = this.getUnitIcon();
        this.unitIcon.setX(14.0f);
        this.unitIcon.setY(38.0f);
        this.addActor(this.unitIcon);
        this.unitIcon2 = this.getUnitIcon();
        this.unitIcon2.setX(10.0f);
        this.unitIcon2.setY(38.0f);
        this.addActor(this.unitIcon2);
        this.unitIcon2.setVisible(false);
        this.nameUnit = new Label((CharSequence)unitTypeData.name, labelStyle);
        this.nameUnit.setY(this.unitPlace.getHeight() + 36.0f + 12.0f);
        this.nameUnit.setX((this.unitPlace.getWidth() - this.nameUnit.getWidth()) / 2.0f);
        this.addActor(this.nameUnit);
        this.createBtn = new TextButton(this.model.lang.get("window.barrack.create"), this.assets.getUi().redButtonStyle);
        this.createBtn.setY(0.0f);
        this.createBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Commander.getInstance().CreateUnit(unitTypeData.id);
            }
        });
        this.addActor(this.createBtn);
        this.slotFade = Component.getImage(this.atlas, "slot_fade");
        this.slotFade.setX(6.0f);
        this.slotFade.setY(40.0f);
        this.addActor(this.slotFade);
        Label.LabelStyle white16 = new Label.LabelStyle();
        white16.font = this.assets.getFont().arialBold16;
        white16.fontColor = Color.WHITE;
        this.timer = new Label((CharSequence)"00:00", white16);
        this.timer.setX(this.unitPlace.getX() + (this.unitPlace.getWidth() - this.timer.getWidth()) / 2.0f);
        this.timer.setY(this.unitPlace.getY() + (this.unitPlace.getHeight() - this.timer.getHeight()) / 2.0f);
        this.addActor(this.timer);
        this.numUnitsText = new Label((CharSequence)"x2", white16);
        this.numUnitsText.setX(this.unitPlace.getX() + (this.unitPlace.getWidth() - this.numUnitsText.getWidth()) / 2.0f);
        this.numUnitsText.setY(this.unitPlace.getY() + 5.0f);
        this.numUnitsText.setTouchable(Touchable.disabled);
        this.addActor(this.numUnitsText);
        Label.LabelStyle white14 = new Label.LabelStyle();
        white14.font = this.assets.getFont().arialBold14;
        white14.fontColor = Color.WHITE;
        this.lockText = new Label((CharSequence)this.model.lang.format("window.barrack.unit_lock_level", 0), white14);
        this.lockText.setY(4.0f);
        this.addActor(this.lockText);
    }

    private Image getUnitIcon() {
        AvatarData avatar = this.model.player.selectedAvatar;
        String unitIconName = "unit_icon%s0001";
        switch (this.unitTypeData.code) {
            case "farn": {
                unitIconName = "unit_icon%s0002";
                break;
            }
            case "havy": {
                unitIconName = "unit_icon%s0003";
            }
        }
        return Component.getImage(this.atlas, String.format(unitIconName, avatar.fractionId == 1L ? "_oseon" : ""));
    }

    public void update() {
        AvatarData avatar = this.model.player.selectedAvatar;
        int numUnits = avatar.getNumUnitsType(this.unitTypeData.id);
        if (avatar.level < this.unitTypeData.minLevel) {
            this.lockText.setText(this.model.lang.format("window.barrack.unit_lock_level", this.unitTypeData.minLevel));
            this.lockText.setVisible(true);
            this.numUnitsText.setVisible(false);
            this.setInactive();
            this.enable = false;
        } else {
            this.lockText.setVisible(false);
            this.numUnitsText.setVisible(true);
            this.numUnitsText.setText("x" + numUnits);
            if (numUnits == 2) {
                this.unitIcon2.setVisible(true);
                this.unitIcon.setX(20.0f);
            } else {
                this.unitIcon.setX(14.0f);
                this.unitIcon2.setVisible(false);
            }
            this.enable = true;
        }
        this.updateEnableButton();
    }

    public void updateTimer(String text) {
        if (!this.timer.isVisible()) {
            this.timer.setVisible(true);
        }
        this.timer.setText(text);
    }

    public void hideTimer() {
        if (this.timer.isVisible()) {
            this.timer.setVisible(false);
        }
    }

    private void updateEnableButton() {
        AvatarData avatar = this.model.player.selectedAvatar;
        int numUnits = avatar.getNumUnitsType(this.unitTypeData.id);
        boolean limit = avatar.level >= 5 ? numUnits >= 1 : numUnits >= this.unitTypeData.limit;
        this.createBtn.setDisabled(limit || avatar.units.size >= 3);
    }

    public void setInactive() {
        this.unitIcon.setColor(Color.GRAY);
        this.unitPlace.setColor(Color.GRAY);
        this.unitIcon2.setColor(Color.GRAY);
        this.createBtn.setVisible(false);
    }

    public void setActive() {
        this.unitIcon.setColor(Color.WHITE);
        this.unitPlace.setColor(Color.WHITE);
        this.unitIcon2.setColor(Color.WHITE);
        this.createBtn.setVisible(true);
    }

    public UnitTypeData getUnitTypeData() {
        return this.unitTypeData;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public TextButton getCreateBtn() {
        return this.createBtn;
    }

    public Image getUnit() {
        return this.slotFade;
    }
}

