/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.battle;

import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.battle.BattleData;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.warning.WarningWindow;

public class BattleEndObserverWindow
extends WarningWindow {
    public BattleEndObserverWindow(String title, String message, String answer) {
        super(WarningWindow.Type.INFO, title, message, answer);
    }

    public static GameWindow create(BattleData battleData) {
        AvatarData winner = battleData.getAvatar(battleData.battleResult.getWinnerId());
        AvatarData loser = battleData.getAvatar(battleData.battleResult.getLoserId());
        String message = String.format("\u041d\u0438\u0447\u044c\u044f!\n\u0420\u0430\u0443\u043d\u0434\u043e\u0432: %d", battleData.round);
        if (winner != null && loser != null) {
            message = String.format("\u0412 \u044d\u0442\u043e\u043c \u0431\u043e\u044e %s \u043e\u0434\u0435\u0440\u0436\u0430\u043b \u043f\u043e\u0431\u0435\u0434\u0443 \u043d\u0430\u0434 %s!\n\u0420\u0430\u0443\u043d\u0434\u043e\u0432: %d", winner.name, loser.name, battleData.round);
        }
        Model model = Model.getInstance();
        BattleEndObserverWindow wnd = new BattleEndObserverWindow(model.lang.get("window.battle_end"), message, "Press F");
        return wnd;
    }
}

