/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.battle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.battle.BattleData;
import com.tpwar.game.managers.UnitManager;
import com.tpwar.game.windows.AnimatedActor;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.avatar.ArtefactType;
import packet.Battle;
import packet.Transport;

public class BattleEndWindow
extends DefaultWindow {
    private Battle.BattleResultDto resultData;
    private TextureAtlas profileAtlas = (TextureAtlas)assets.get("ui/profile.atlas");
    private TextureAtlas commonAtlas = assets.getCommonAtlas();
    private BattleData battle;

    public BattleEndWindow(BattleData battle) {
        this.battle = battle;
        this.resultData = battle.battleResult;
    }

    @Override
    public void openHandler() {
        Animation<TextureRegion> iconAnimation;
        String result;
        this.setTitle(this.model.lang.get("window.battle_end"));
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        AvatarData avatar = this.model.player.selectedAvatar;
        float frameDuration = 0.083333336f;
        int offsetX = 24;
        if (avatar.id == this.resultData.getWinnerId()) {
            result = this.model.lang.get("window.battle_end.win");
            iconAnimation = new Animation<TextureRegion>(frameDuration, assets.extractRegions(atlas, "result_win_icon"));
        } else if (avatar.id == this.resultData.getLoserId()) {
            result = this.model.lang.get("window.battle_end.defeat");
            iconAnimation = new Animation<TextureRegion>(frameDuration, assets.extractRegions(atlas, "result_defeat_icon"));
            offsetX = 62;
        } else {
            result = this.model.lang.get("window.battle_end.draw");
            iconAnimation = new Animation<TextureRegion>(frameDuration, assets.extractRegions(atlas, "result_draw_icon"));
            offsetX = 36;
        }
        iconAnimation.setPlayMode(Animation.PlayMode.NORMAL);
        AnimatedActor anim = new AnimatedActor(iconAnimation);
        Container<AnimatedActor> container = new Container<AnimatedActor>(anim);
        container.clip();
        this.getContentTable().add(new Container<Container<AnimatedActor>>(container)).height(126.0f).left().padLeft(offsetX).bottom().expandX().row();
        Label.LabelStyle resultStyle = new Label.LabelStyle();
        resultStyle.font = BattleEndWindow.assets.getFont().centryGothicBold20;
        resultStyle.fontColor = Color.valueOf("#EFD774");
        Label resultLabel = new Label((CharSequence)result, resultStyle);
        this.getContentTable().add(resultLabel).expandX().row();
        this.getContentTable().add(this.reward()).expandX().padTop(6.0f).row();
        int units = avatar.id == this.resultData.getLoserId() ? 0 : this.battle.getNumAliveUnits();
        Label.LabelStyle style = new Label.LabelStyle(BattleEndWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        Label unitLeft = new Label((CharSequence)this.model.lang.get("window.battle_end.units_left"), style);
        style = new Label.LabelStyle(BattleEndWindow.assets.getFont().arialBold14, Color.valueOf("#EFD774"));
        final Label unitLeftNum = new Label((CharSequence)String.valueOf(units), style);
        unitLeftNum.setAlignment(16);
        Table unitLeftTable = new Table();
        unitLeftTable.add(unitLeft).expandX().left();
        unitLeftTable.add(unitLeftNum).expandX().right();
        this.getContentTable().add(unitLeftTable).expandX().width(160.0f).row();
        if (units < 3 && !avatar.inTutorial()) {
            Label restoreUnits = new Label((CharSequence)"\u0425\u043e\u0442\u0438\u0442\u0435 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0441\u044e \u0430\u0440\u043c\u0438\u044e \u0441\u0440\u0430\u0437\u0443?", style);
            restoreUnits.setWrap(true);
            restoreUnits.setAlignment(1);
            Table restoreUnitsTable = new Table();
            restoreUnitsTable.add(new Image(this.commonAtlas.findRegion("unit_star"))).top();
            restoreUnitsTable.add(restoreUnits).width(197.0f);
            restoreUnitsTable.add(new Image(this.commonAtlas.findRegion("unit_star"))).top();
            this.getContentTable().add(restoreUnitsTable).expandX().padTop(10.0f).padBottom(10.0f);
            final TextButton buyUnits = new TextButton(this.model.lang.get("window.barrack.buy_now"), BattleEndWindow.assets.getUi().buyButtonStyle);
            buyUnits.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    MessageListener messageListener = new MessageListener(){

                        @Override
                        public void handleMessage(int code, Object data, Transport.Packet msg) {
                            BattleEndWindow.this.model.removeListeners(this);
                            unitLeftNum.setText("3");
                            buyUnits.setDisabled(true);
                        }
                    };
                    BattleEndWindow.this.model.addListener(messageListener, Cmd.UpdateUnits.getCode());
                    UnitManager.buyUnits();
                }
            });
            this.getButtonTable().add(buyUnits);
            this.getButtonTable().padBottom(6.0f);
        } else {
            this.getContentTable().padBottom(10.0f);
        }
    }

    private Table reward() {
        Table result = new Table();
        Label.LabelStyle style = new Label.LabelStyle();
        style.font = BattleEndWindow.assets.getFont().arialBold14;
        style.fontColor = Color.valueOf("#F0E9CF");
        Label rewardLabel = new Label((CharSequence)"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442", style);
        result.add(rewardLabel).expandX().row();
        TextureAtlas atlas = assets.getWindowAtlas();
        Table giftTable = new Table();
        giftTable.setBackground(assets.getNinePatchDrawable(atlas, "content_background", 6, 6, 6, 6));
        giftTable.defaults().space(6.0f);
        giftTable.add(this.energy());
        giftTable.add(this.xp());
        style = new Label.LabelStyle(BattleEndWindow.assets.getFont().arialBold14, Color.valueOf("EFD774"));
        for (Battle.ArtefactRewardDto a : this.resultData.getArtefactsList()) {
            ArtefactType artefactType = this.storage.artefactType.get(a.getArtefactTypeId());
            String iconName = "dead_ray_icon";
            switch (artefactType.code) {
                case "double_power": {
                    iconName = "double_power_icon";
                    break;
                }
                case "dynamic_shield": {
                    iconName = "dynamic_shield_icon";
                    break;
                }
                case "heal": {
                    iconName = "heal_icon";
                }
            }
            Table artefact = new Table();
            artefact.add(new Image(this.profileAtlas.findRegion(iconName))).row();
            artefact.add(new Label((CharSequence)("x" + a.getCount()), style));
            giftTable.add(artefact);
        }
        result.add(giftTable).padTop(6.0f).padBottom(6.0f);
        return result;
    }

    private Table energy() {
        Stack stack = new Stack();
        stack.add(new Image(this.profileAtlas.findRegion("slot")));
        stack.add(new Container<Image>(new Image(this.commonAtlas.findRegion("energy_icon"))));
        Label.LabelStyle style = new Label.LabelStyle(BattleEndWindow.assets.getFont().arialBold14, Color.valueOf("EFD774"));
        Table energy = new Table();
        energy.add(stack).row();
        energy.add(new Label((CharSequence)("x" + this.resultData.getEnergy()), style));
        return energy;
    }

    private Table xp() {
        Stack stack = new Stack();
        stack.add(new Image(this.profileAtlas.findRegion("slot")));
        stack.add(new Container<Image>(new Image(this.commonAtlas.findRegion("xp"))));
        Label.LabelStyle style = new Label.LabelStyle(BattleEndWindow.assets.getFont().arialBold14, Color.valueOf("EFD774"));
        Table xp = new Table();
        xp.add(stack).row();
        xp.add(new Label((CharSequence)("" + this.resultData.getExp()), style));
        return xp;
    }
}

