/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.chat;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Component;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import packet.Static;

public class SelectChatWindow
extends DefaultWindow {
    private static final Storage storage = Storage.getInstance();
    private static final Model model = Model.getInstance();
    private final Commander commander = Commander.getInstance();
    private TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");

    public SelectChatWindow() {
        super("");
    }

    @Override
    public void openHandler() {
        this.setTitle(SelectChatWindow.model.lang.get("window.select_chat"));
        this.getContentTable().pad(20.0f);
        this.getContentTable().defaults().space(10.0f);
        ImageButton comChatBtn = Component.getImageButton(this.atlas, "com_chat_bnt");
        comChatBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SelectChatWindow.this.commander.ChatActionJoin(SelectChatWindow.storage.chat.getGeneral().getId());
                SelectChatWindow.this.closeHandler();
            }
        });
        this.getContentTable().add(comChatBtn).expand();
        AvatarData avatarData = SelectChatWindow.model.player.selectedAvatar;
        final Static.StaticFaction fraction = SelectChatWindow.storage.faction.get(avatarData.fractionId);
        boolean isOseon = SelectChatWindow.storage.faction.isOseon(fraction.getCode());
        ImageButton fractionChatBtn = Component.getImageButton(this.atlas, isOseon ? "oseon_chat_btn" : "wayland_chat_btn");
        fractionChatBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SelectChatWindow.this.commander.ChatActionJoin(SelectChatWindow.storage.chat.getFraction(fraction).getId());
                SelectChatWindow.this.closeHandler();
            }
        });
        this.getContentTable().add(fractionChatBtn).expand();
        ImageButton clanChatBtn = Component.getImageButton(this.atlas, "clan_chat_btn");
        clanChatBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SelectChatWindow.this.commander.ChatActionJoin(SelectChatWindow.storage.chat.getClan().getId());
                SelectChatWindow.this.closeHandler();
            }
        });
        this.getContentTable().add(clanChatBtn).expand();
        clanChatBtn.setDisabled(avatarData.clanId == 0L);
        if (avatarData.isAdmin()) {
            ImageButton adminChatBtn = Component.getImageButton(this.atlas, "admin_chat_btn");
            adminChatBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    SelectChatWindow.this.commander.ChatActionJoin(SelectChatWindow.storage.chat.getAdmin().getId());
                    SelectChatWindow.this.closeHandler();
                }
            });
            this.getContentTable().add(adminChatBtn).expand();
        }
        this.getContentTable().row();
        Label generalChatDescription = new Label((CharSequence)SelectChatWindow.model.lang.get("window.select_chat.description.general"), new Label.LabelStyle(SelectChatWindow.assets.getFont().arialBold16, Color.WHITE));
        generalChatDescription.setWrap(true);
        generalChatDescription.setAlignment(1);
        this.getContentTable().add(generalChatDescription).fill().top();
        Label fractionChatDescription = new Label((CharSequence)SelectChatWindow.model.lang.format("window.select_chat.description.fraction", fraction.getName()), new Label.LabelStyle(SelectChatWindow.assets.getFont().arialBold16, Color.WHITE));
        fractionChatDescription.setWrap(true);
        fractionChatDescription.setAlignment(1);
        this.getContentTable().add(fractionChatDescription).fill().top();
        Label clanChatDescription = new Label((CharSequence)SelectChatWindow.model.lang.format("window.select_chat.description.clan", fraction.getName()), new Label.LabelStyle(SelectChatWindow.assets.getFont().arialBold16, Color.WHITE));
        clanChatDescription.setWrap(true);
        clanChatDescription.setAlignment(1);
        this.getContentTable().add(clanChatDescription).fill().top();
        if (avatarData.isAdmin()) {
            Label adminChatDescription = new Label((CharSequence)"\u0427\u0430\u0442 \u0430\u0434\u043c\u0438\u043d\u043e\u0432", new Label.LabelStyle(SelectChatWindow.assets.getFont().arialBold16, Color.WHITE));
            adminChatDescription.setWrap(true);
            adminChatDescription.setAlignment(1);
            this.getContentTable().add(adminChatDescription).fill().top();
        }
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
    }
}

