/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.chroncle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.massage.MessageWindow;
import com.tpwar.storage.Storage;
import packet.Battle;

public class ChronicleWidget
extends Table {
    private static final int ARENA_BATTLE = 1;
    private final Model model = Model.getInstance();

    public ChronicleWidget(Assets assets, Storage storage, final Battle.BattleChronicleDto bcd) {
        String name1;
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        Image back = new Image(assets.getNinePatchDrawable(atlas, "battle_chronicle_bg", 4, 4, 22, 0));
        Table content = new Table();
        content.pad(2.0f, 6.0f, 6.0f, 6.0f);
        content.defaults().space(6.0f);
        boolean isArenaBattle = (bcd.getFlags() & 1) != 0;
        Table top = new Table();
        Color fractionColor = Color.valueOf(storage.faction.getColor(bcd.getFractionId1()));
        String string = name1 = bcd.getName1().contains("default_illusion") ? "Citadel Illusion" : bcd.getName1();
        if (isArenaBattle && bcd.getName1().contains("default_illusion")) {
            fractionColor = Color.BLACK;
            name1 = "Dark Illusion";
        }
        Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold16, fractionColor);
        Label avatarName1 = new Label((CharSequence)String.format("%s[%d]", name1, bcd.getLevel1()), style);
        top.add(avatarName1).width(130.0f).top();
        Label vs = new Label((CharSequence)"VS", new Label.LabelStyle(assets.getFont().arialBold16, Color.valueOf("#EFD774")));
        vs.setAlignment(1);
        top.add(vs).growX().center().top();
        fractionColor = Color.valueOf(storage.faction.getColor(bcd.getFractionId2()));
        String name2 = bcd.getName2();
        if (isArenaBattle && (bcd.getName2().contains("default_illusion") || bcd.getName2().contains("Dark Illusion"))) {
            fractionColor = Color.LIGHT_GRAY;
            name2 = "Dark Illusion";
        }
        style = new Label.LabelStyle(assets.getFont().arialBold16, fractionColor);
        Label avatarName2 = new Label((CharSequence)String.format("%s[%d]", name2, bcd.getLevel2()), style);
        avatarName2.setAlignment(16);
        top.add(avatarName2).width(130.0f).right().top().row();
        content.add(top).expandX().fillX().row();
        Image energyIcon = new Image(atlas.findRegion("energy_icon_small"));
        Image expIcon = new Image(atlas.findRegion("xp"));
        style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
        Label energy = new Label((CharSequence)String.valueOf(bcd.getEnergy()), style);
        Label exp = new Label((CharSequence)String.valueOf(bcd.getExperience()), style);
        Table reward = new Table();
        reward.defaults().spaceBottom(10.0f);
        reward.add(energyIcon).expandX().left();
        reward.add(energy).expandX().right().row();
        reward.add(expIcon).expandX().left();
        reward.add(exp).expandX().right().row();
        Table middle = new Table();
        middle.add(reward).growX().padTop(6.0f).padBottom(6.0f);
        Image resultIcon = bcd.getExperience() < 0 ? new Image(assets.getDrawable(atlas, "defeat_icon")) : (bcd.getExperience() > 0 ? new Image(assets.getDrawable(atlas, "win_icon")) : new Image(assets.getDrawable(atlas, "draw_icon")));
        middle.add(resultIcon).expand();
        ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(atlas, "message_btn_up");
        btnStyle.down = assets.getDrawable(atlas, "message_btn_down");
        ImageButton msgBtn = new ImageButton(btnStyle);
        msgBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AvatarData avatar = Model.getInstance().player.selectedAvatar;
                String avatarName = avatar.name.equals(bcd.getName1()) ? bcd.getName2() : bcd.getName1();
                MessageWindow wnd = new MessageWindow(avatarName);
                WindowManager.getInstance().open(wnd, true);
            }
        });
        middle.add(msgBtn).expand().right().padRight(26.0f);
        content.add(middle).expandX().fillX().row();
        style = new Label.LabelStyle(assets.getFont().arial14, Color.WHITE);
        Label startTime = new Label((CharSequence)(this.model.lang.get("window.chronicle.date") + " " + TimeUtils.convertTime(bcd.getStartTime())), style);
        startTime.setAlignment(8);
        content.add(startTime).expandX().left();
        this.add(new Stack(back, content));
    }
}

