/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.chroncle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.chroncle.ChronicleWidget;
import com.tpwar.storage.Storage;
import java.util.Comparator;
import packet.Battle;

public class ChronicleWindow
extends DefaultWindow {
    private Storage storage = Storage.getInstance();

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.chronicle"));
        AvatarData avatar = this.model.player.selectedAvatar;
        Table content = new Table();
        content.defaults().space(6.0f);
        Array<Battle.BattleChronicleDto> chronicles = new Array<Battle.BattleChronicleDto>(avatar.chronicles);
        chronicles.sort(new Comparator<Battle.BattleChronicleDto>(){

            @Override
            public int compare(Battle.BattleChronicleDto o1, Battle.BattleChronicleDto o2) {
                if (o1.getStartTime() < o2.getStartTime()) {
                    return 1;
                }
                if (o1.getStartTime() > o2.getStartTime()) {
                    return -1;
                }
                return 0;
            }
        });
        for (Battle.BattleChronicleDto chroniclesData : chronicles) {
            ChronicleWidget cw = new ChronicleWidget(assets, this.storage, chroniclesData);
            content.add(cw).expand().row();
        }
        if (chronicles.isEmpty()) {
            Label.LabelStyle style = new Label.LabelStyle(ChronicleWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
            Label empty = new Label((CharSequence)this.model.lang.get("window.chronicle.empty"), style);
            empty.setAlignment(1, 1);
            content.add(empty).expand().size(300.0f, 300.0f);
        }
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        ScrollPane scrollPane = new ScrollPane((Actor)content);
        Container<ScrollPane> scrollContainer = new Container<ScrollPane>(scrollPane);
        scrollContainer.top();
        scrollContainer.setBackground(assets.getNinePatchDrawable(atlas, "element_back", 4, 4, 4, 4));
        this.getContentTable().add(scrollContainer).pad(10.0f).height(340.0f).expand();
    }
}

