/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.citadel;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.citadel.GuildInfoWidget;
import com.tpwar.game.windows.citadel.GuildProgressWidget;
import com.tpwar.game.windows.citadel.GuildWidget;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import java.util.List;
import packet.Guild;
import packet.Static;
import packet.Transport;

public class CitadelWindow
extends DefaultWindow
implements MessageListener {
    private Storage storage = Storage.getInstance();
    private ButtonGroup<Button> buttons = new ButtonGroup();
    private GuildInfoWidget guildInfo;
    private GuildProgressWidget guildProgress;
    private Table taskBlock;
    private AvatarData avatarData;
    private Label taskDescription;
    private VerticalGroup guildContent;
    private TextButton actionButton;

    public CitadelWindow() {
        super("", 660, 440);
        this.avatarData = this.model.player.selectedAvatar;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.citadel"));
        Static.StaticFaction fraction = this.storage.faction.get(this.avatarData.fractionId);
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        TextureRegionDrawable wallFlag = this.storage.faction.isOseon(fraction.getCode()) ? new TextureRegionDrawable(atlas.findRegion("oseon_wall_flag")) : new TextureRegionDrawable(atlas.findRegion("wayland_wall_flag"));
        Table rightSide = new Table();
        TextureAtlas windowAtlas = (TextureAtlas)assets.get("ui/window.atlas");
        rightSide.defaults().pad(6.0f);
        Label.LabelStyle style = new Label.LabelStyle(CitadelWindow.assets.getFont().arial14, Color.WHITE);
        Label citadelDescription = new Label((CharSequence)this.model.lang.get("window.citadel.description"), style);
        citadelDescription.setWrap(true);
        rightSide.add(citadelDescription).left().top().width(472.0f).row();
        Table guildBlock = new Table();
        guildBlock.setBackground(assets.getNinePatchDrawable(windowAtlas, "content_background", 1, 1, 1, 1));
        this.guildContent = new VerticalGroup();
        this.guildContent.space(6.0f);
        this.taskBlock = this.task(atlas);
        this.guildInfo = new GuildInfoWidget(assets);
        ScrollPane pane = new ScrollPane((Actor)this.guildContent);
        guildBlock.add(pane).expand().top().pad(6.0f);
        rightSide.add(guildBlock).expand().fill().row();
        this.actionButton = new TextButton("\u0412\u0441\u0442\u0443\u043f\u0438\u0442\u044c", assets.getDefaultSkin(), "yellow-btn");
        this.actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Static.StaticGuild guild = (Static.StaticGuild)CitadelWindow.this.buttons.getChecked().getUserObject();
                if (CitadelWindow.this.avatarData.guildId == guild.getId()) {
                    final WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0413\u0438\u043b\u044c\u0434\u0438\u044f", "\u0412\u0430\u0448 \u0432\u0437\u043d\u043e\u0441 \u043d\u0435 \u0432\u0435\u0440\u043d\u0435\u0442\u0441\u044f, \u0432\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u043e\u043a\u0438\u043d\u0443\u0442\u044c \u0433\u0438\u043b\u044c\u0434\u0438\u044e?", "\u0414\u0430");
                    wnd.setActionlistener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            Commander.getInstance().GuildLeave();
                            wnd.closeHandler();
                        }
                    });
                    WindowManager.getInstance().open(wnd, true);
                    return;
                }
                if (CitadelWindow.this.avatarData.hasGuild()) {
                    String text = ((CitadelWindow)CitadelWindow.this).model.lang.format("window.citadel.guild.avatar_has_guild", CitadelWindow.this.avatarData.getGuild().getName());
                    WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0413\u0438\u043b\u044c\u0434\u0438\u044f", text, "\u041e\u043a");
                    WindowManager.getInstance().open(wnd, true);
                } else if (FinanceManager.checkEnergy(CitadelWindow.this.avatarData, CitadelWindow.this.storage.guild.calcEntryPrice(guild, CitadelWindow.this.avatarData.level))) {
                    ((CitadelWindow)CitadelWindow.this).soundSystem.fx.play("sound/fx/24. Join_guild.mp3");
                    Commander.getInstance().GuildJoin(guild.getId());
                }
            }
        });
        rightSide.add(this.actionButton).padBottom(2.0f);
        Table leftSide = new Table();
        leftSide.add(new Image(wallFlag)).expand().top().row();
        leftSide.add(this.menu(atlas)).expand();
        this.getContentTable().add(leftSide).expand().top().fill().padLeft(14.0f);
        this.getContentTable().add(rightSide).top().padTop(14.0f).padRight(14.0f).padBottom(14.0f).fill();
        this.model.addListener(this, Cmd.AvatarUpdate.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        this.setGuild((Static.StaticGuild)this.buttons.getChecked().getUserObject());
    }

    private Table task(TextureAtlas atlas) {
        Table taskBlock = new Table();
        taskBlock.setBackground(assets.getNinePatchDrawable(atlas, "task_guild_bg", 4, 4, 4, 4));
        Label.LabelStyle style = new Label.LabelStyle(CitadelWindow.assets.getFont().arial14, Color.WHITE);
        this.taskDescription = new Label((CharSequence)"", style);
        this.taskDescription.setWrap(true);
        taskBlock.add(this.taskDescription).width(442.0f).pad(4.0f);
        return taskBlock;
    }

    private void setGuild(Static.StaticGuild guild) {
        GuildWidget guildWidget;
        if (this.avatarData.guildId == guild.getId()) {
            if (this.guildProgress == null || this.guildProgress.guildId != this.avatarData.guildId) {
                this.guildProgress = new GuildProgressWidget(assets);
            }
            guildWidget = this.guildProgress;
            this.actionButton.setText("\u041f\u043e\u043a\u0438\u043d\u0443\u0442\u044c");
            this.actionButton.setDisabled(false);
        } else {
            guildWidget = this.guildInfo;
            this.actionButton.setText("\u0412\u0441\u0442\u0443\u043f\u0438\u0442\u044c");
            Guild.AvatarTaskDto task = this.avatarData.getTask(guild.getTaskTypeId());
            int taskNum = task == null ? 0 : task.getScore();
            int requiredTaskNum = this.storage.guildRanks.getRanksByGuildId(guild.getId()).get(0).getRequiredNumScoreTask();
            this.actionButton.setDisabled(taskNum < requiredTaskNum);
        }
        guildWidget.setGuild(guild, this.avatarData);
        this.guildContent.clear();
        this.guildContent.addActor(guildWidget);
        this.guildContent.addActor(this.taskBlock);
        TaskTypeData taskType = this.storage.taskType.get(guild.getTaskTypeId());
        if (taskType.isDefence()) {
            Static.StaticFaction faction = this.storage.faction.get(this.avatarData.fractionId);
            this.taskDescription.setText(this.model.lang.format("window.citadel.guild.task.defense", faction.getName()));
        } else if (taskType.isInvade()) {
            Static.StaticFaction faction = this.storage.faction.getOpposite(this.avatarData.fractionId);
            this.taskDescription.setText(this.model.lang.format("window.citadel.guild.task.invade", faction.getName()));
        } else {
            this.taskDescription.setText(this.model.lang.get("window.citadel.guild.task." + taskType.data.getCode()));
        }
    }

    private VerticalGroup menu(TextureAtlas atlas) {
        VerticalGroup menu = new VerticalGroup();
        List<Static.StaticGuild> guilds = this.storage.guild.getAll();
        for (final Static.StaticGuild staticGuild : guilds) {
            TaskTypeData taskType = this.storage.taskType.get(staticGuild.getTaskTypeId());
            ImageTextButton button = new ImageTextButton(staticGuild.getName(), this.buttonStyle(atlas, switch (taskType.data.getCode()) {
                case "mine" -> "guild_btn_icon0002";
                case "defense" -> "guild_btn_icon0003";
                case "invade" -> "guild_btn_icon0004";
                case "devastation" -> "guild_btn_icon0005";
                default -> "guild_btn_icon0001";
            }));
            button.setUserObject(staticGuild);
            button.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    CitadelWindow.this.setGuild(staticGuild);
                }
            });
            menu.addActor(button);
            menu.space(5.0f);
            menu.fill();
            this.buttons.add(button);
        }
        return menu;
    }

    private ImageTextButton.ImageTextButtonStyle buttonStyle(TextureAtlas atlas, String guildBtnIcon) {
        ImageTextButton.ImageTextButtonStyle btnStyle = new ImageTextButton.ImageTextButtonStyle();
        btnStyle.checked = assets.getNinePatchDrawable(atlas, "max_btn_down", 6, 6, 1, 1);
        btnStyle.up = assets.getNinePatchDrawable(atlas, "max_btn_up", 6, 6, 1, 1);
        btnStyle.font = CitadelWindow.assets.getFont().arialBold14;
        btnStyle.fontColor = Color.valueOf("#EFD774");
        btnStyle.imageChecked = new TextureRegionDrawable(atlas.findRegion(guildBtnIcon));
        btnStyle.imageUp = new TextureRegionDrawable(atlas.findRegion(guildBtnIcon));
        return btnStyle;
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }
}

