/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.citadel;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.citadel.GuildWidget;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import java.util.List;
import packet.Guild;
import packet.Static;

public class GuildInfoWidget
extends GuildWidget {
    private Label name;
    private Label description;
    private Label actionValue;
    private Label tasksValue;
    private Label levelValue;
    private Label enterPriceValue;
    private Assets assets;
    private Storage storage;
    private Model model;

    public GuildInfoWidget(Assets assets) {
        this.assets = assets;
        this.model = Model.getInstance();
        this.storage = Storage.getInstance();
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        this.defaults().expand().left().top().padLeft(10.0f).padTop(6.0f);
        this.setBackground(assets.getNinePatchDrawable(atlas, "guild_bg", 1, 1, 2, 2));
        Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
        this.name = new Label((CharSequence)"", style);
        this.add(this.name).row();
        style = new Label.LabelStyle(assets.getFont().arial14, Color.WHITE);
        this.description = new Label((CharSequence)"", style);
        this.description.setWrap(true);
        this.add(this.description).width(430.0f).row();
        style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
        Table info = new Table();
        info.defaults().expand().left();
        Label actionName = new Label((CharSequence)"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435:", new Label.LabelStyle(style));
        info.add(actionName);
        this.actionValue = new Label((CharSequence)"", new Label.LabelStyle(style));
        this.actionValue.getStyle().fontColor = Color.valueOf("#EFD774");
        info.add(this.actionValue);
        Label tasksName = new Label((CharSequence)"\u0417\u0430\u0434\u0430\u043d\u0438\u0439:", new Label.LabelStyle(style));
        info.add(tasksName);
        this.tasksValue = new Label((CharSequence)"", new Label.LabelStyle(style));
        info.add(this.tasksValue);
        Label levelName = new Label((CharSequence)"\u0414\u043e\u0441\u0442\u0443\u043f:", new Label.LabelStyle(style));
        info.add(levelName);
        this.levelValue = new Label((CharSequence)"", new Label.LabelStyle(style));
        info.add(this.levelValue);
        Label enterPriceName = new Label((CharSequence)"\u0412\u0437\u043d\u043e\u0441:", new Label.LabelStyle(style));
        info.add(enterPriceName);
        this.enterPriceValue = new Label((CharSequence)"", new Label.LabelStyle(style));
        info.add(this.enterPriceValue);
        this.add(info).expand().padBottom(6.0f).fill();
    }

    @Override
    public void setGuild(Static.StaticGuild guild, AvatarData avatar) {
        this.name.setText(guild.getName());
        TaskTypeData taskType = this.storage.taskType.get(guild.getTaskTypeId());
        List<Static.StaticGuildRank> ranks = this.storage.guildRanks.getRanksByGuildId(guild.getId());
        Static.StaticGuildRank rank = ranks.get(0);
        this.actionValue.setText(this.storage.guildRanks.getModif(taskType, rank));
        Guild.AvatarTaskDto task = avatar.getTask(guild.getTaskTypeId());
        int taskNum = task == null ? 0 : task.getScore();
        this.tasksValue.setText(taskNum + "/" + rank.getRequiredNumScoreTask());
        this.tasksValue.getStyle().fontColor = taskNum < rank.getRequiredNumScoreTask() ? Color.RED : Color.GREEN;
        this.levelValue.setText(guild.getMinLevel() + " \u0443\u0440.");
        this.levelValue.getStyle().fontColor = avatar.level < guild.getMinLevel() ? Color.RED : Color.GREEN;
        int enterPrice = this.storage.guild.calcEntryPrice(guild, avatar.level);
        this.enterPriceValue.setText(String.valueOf(enterPrice));
        this.enterPriceValue.getStyle().fontColor = avatar.energy < enterPrice ? Color.RED : Color.GREEN;
        this.description.setText(this.model.lang.get("window.citadel.guild.desc." + taskType.data.getCode()));
    }
}

