/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.citadel;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ProgressBar;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.citadel.GuildWidget;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import packet.Static;

public class GuildProgressWidget
extends GuildWidget {
    private Assets assets;
    private Storage storage;
    private Label name;
    private Label description;
    private Model model;
    public long guildId;
    private ProgressBar progressBar;
    private Label tasks;
    private Static.StaticGuildRank nextRank;
    private Static.StaticGuildRank currentRank;
    private TaskTypeData taskType;

    public GuildProgressWidget(Assets assets) {
        this.assets = assets;
        this.storage = Storage.getInstance();
        this.model = Model.getInstance();
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        AvatarData avatar = this.model.player.selectedAvatar;
        this.guildId = avatar.guildId;
        this.defaults().expand().left().top().padLeft(10.0f).padTop(6.0f);
        this.setBackground(assets.getNinePatchDrawable(atlas, "guild_bg", 1, 1, 2, 2));
        Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
        this.name = new Label((CharSequence)"", style);
        this.add(this.name).row();
        style = new Label.LabelStyle(assets.getFont().arial14, Color.WHITE);
        this.description = new Label((CharSequence)"", style);
        this.description.setWrap(true);
        this.add(this.description).width(430.0f).row();
        ProgressBar.ProgressBarStyle progressBarStyle = new ProgressBar.ProgressBarStyle();
        progressBarStyle.background = assets.getNinePatchDrawable(atlas, "progress_bg", 2, 2, 1, 1);
        progressBarStyle.knobBefore = assets.getNinePatchDrawable(atlas, "progress_line", 0, 30, 0, 0);
        this.progressBar = new ProgressBar(0.0f, 1.0f, 0.01f, false, progressBarStyle);
        this.progressBar.setValue(0.0f);
        this.tasks = new Label((CharSequence)"", new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE));
        this.tasks.setAlignment(1);
        Stack progressStack = new Stack();
        progressStack.addActor(this.progressBar);
        progressStack.addActor(this.tasks);
        Table progress = new Table();
        this.currentRank = avatar.getGuildRank();
        this.nextRank = this.storage.guildRanks.getNextGuildRank(avatar.guildId, avatar.getGuildRank().getRank());
        if (this.nextRank == null) {
            this.currentRank = this.storage.guildRanks.getRank(avatar.guildId, this.currentRank.getRank() - 1);
            this.nextRank = avatar.getGuildRank();
        }
        this.taskType = this.storage.taskType.get(avatar.getGuild().getTaskTypeId());
        progress.add(this.getGuildIcon(assets, this.currentRank));
        progress.add(progressStack).width(200.0f).top().padTop(3.0f).padLeft(8.0f).padRight(8.0f);
        progress.add(this.getGuildIcon(assets, this.nextRank)).row();
        style = new Label.LabelStyle(assets.getFont().arialBold14, Color.valueOf("#EFD774"));
        Label currentRankModif = new Label((CharSequence)this.storage.guildRanks.getModif(this.taskType, this.currentRank), style);
        progress.add(currentRankModif);
        Label taskProgress = new Label((CharSequence)"\u0425\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u043d\u0438\u0439", new Label.LabelStyle(assets.getFont().arial14, Color.WHITE));
        progress.add(taskProgress).top();
        Label nextRankModif = new Label((CharSequence)this.storage.guildRanks.getModif(this.taskType, this.nextRank), style);
        progress.add(nextRankModif);
        this.add(progress).center().padBottom(6.0f);
    }

    @Override
    public void setGuild(Static.StaticGuild guild, AvatarData avatar) {
        this.name.setText(guild.getName());
        this.description.setText(this.model.lang.get("window.citadel.guild.progress." + this.taskType.data.getCode()));
        int current = avatar.getTask(guild.getTaskTypeId()).getScore();
        this.tasks.setText(current + "/" + this.nextRank.getRequiredNumScoreTask());
        int requiredNum = this.nextRank.getRequiredNumScoreTask() - this.currentRank.getRequiredNumScoreTask();
        this.progressBar.setValue((float)(current -= this.currentRank.getRequiredNumScoreTask()) / (float)requiredNum);
    }
}

