/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.clan;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import packet.Base;
import packet.Clan;
import packet.Transport;

public class ClanApplicationsWindow
extends DefaultWindow
implements MessageListener {
    private final WindowManager windowManager = WindowManager.getInstance();
    private Table main;
    private Array<Clan.ClanApplicationDto> applicationList;

    public ClanApplicationsWindow(Clan.ClanApplicationList clanApplicationList) {
        super("");
        this.applicationList = new Array(clanApplicationList.getAppsCount());
        for (Clan.ClanApplicationDto application : clanApplicationList.getAppsList()) {
            this.applicationList.add(application);
        }
    }

    public ClanApplicationsWindow(Array<Clan.ClanApplicationDto> applicationList) {
        super("");
        this.applicationList = applicationList;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.clan_applications"));
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).expand().fillX().top().pad(10.0f, 20.0f, 10.0f, 20.0f);
        TextureAtlas atlas = assets.getCommonAtlas();
        TextField.TextFieldStyle textInputStyle = new TextField.TextFieldStyle();
        textInputStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        textInputStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
        textInputStyle.font = ClanApplicationsWindow.assets.getFont().arialBold14;
        textInputStyle.fontColor = Color.WHITE;
        final TextField name = new TextField("", textInputStyle);
        name.setAlignment(1);
        name.setMaxLength(9);
        name.setMessageText(this.model.lang.get("window.clan_exit.name"));
        Container<Image> bottomLine = new Container<Image>(new Image(assets.getDrawable(atlas, "search_clan_line")));
        bottomLine.getActor().getColor().a = 0.5f;
        bottomLine.bottom().padBottom(-4.0f).fillX();
        this.main.add(new Stack(bottomLine, name)).padBottom(14.0f).padTop(10.0f).top().expand();
        TextButton.TextButtonStyle btnStyle = new TextButton.TextButtonStyle();
        btnStyle.up = assets.getNinePatchDrawable(atlas, "simple_btn_up", 4, 4, 2, 2);
        btnStyle.down = assets.getNinePatchDrawable(atlas, "simple_btn_down", 4, 4, 2, 2);
        btnStyle.font = ClanApplicationsWindow.assets.getFont().arialBold14;
        btnStyle.fontColor = Color.WHITE;
        TextButton sendBtn = new TextButton(this.model.lang.get("window.clan_invitations.send"), btnStyle);
        sendBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ClanApplicationsWindow.this.comander.ClanActionInvate(name.getText().trim());
                ((ClanApplicationsWindow)ClanApplicationsWindow.this).soundSystem.fx.play("sound/fx/24. Join_guild.mp3");
                name.setText("");
            }
        });
        this.main.add(sendBtn).expandX().row();
        Table list = new Table();
        list.defaults().space(6.0f);
        for (Clan.ClanApplicationDto app : this.applicationList) {
            list.add(new AvatarLine(app)).growX().row();
        }
        ScrollPane scrollPane = new ScrollPane((Actor)list);
        Table container = new Table();
        container.setBackground(assets.getNinePatchDrawable(atlas, "message_text_bg", 6, 6, 4, 4));
        container.add(scrollPane).growX().expandY().top();
        this.main.add(container).colspan(2).height(200.0f).grow();
        this.model.addListener(this, Cmd.Error.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case Error: {
                Base.ErrorMsg errorMsg = Base.ErrorMsg.parseFrom(msg.getData());
                if (errorMsg.getCode() == 311) {
                    WarningWindow window = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", "window.error.clan_applications.message", "window.error.clan_search.answer");
                    this.windowManager.open(window, true);
                    break;
                }
                if (errorMsg.getCode() != 318) break;
                WarningWindow window = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", "window.error.clan_applications.take_fail", "window.error.clan_search.answer");
                this.windowManager.open(window, true);
                break;
            }
        }
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }

    class AvatarLine
    extends Table {
        public AvatarLine(final Clan.ClanApplicationDto apps) {
            this.defaults().space(6.0f);
            TextureAtlas atlas = assets.getCommonAtlas();
            this.setBackground(assets.getDrawable(atlas, "clan_line_bg"));
            this.padLeft(6.0f).padRight(6.0f);
            ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
            btnStyle.up = assets.getDrawable(atlas, "reject_btn_up");
            btnStyle.down = assets.getDrawable(atlas, "reject_btn_down");
            ImageButton rejectBtn = new ImageButton(btnStyle);
            rejectBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    ClanApplicationsWindow.this.comander.ClanDeleteApplication(apps.getId());
                    AvatarLine.this.removeFromParentCell();
                }
            });
            this.add(rejectBtn);
            String color = ((ClanApplicationsWindow)ClanApplicationsWindow.this).storage.faction.getColor(((ClanApplicationsWindow)ClanApplicationsWindow.this).model.player.selectedAvatar.fractionId);
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.valueOf(color));
            String text = String.format("%s[%d]", apps.getName(), apps.getLevel());
            Label name = new Label((CharSequence)text, style);
            name.setEllipsis(true);
            this.add(name).width(126.0f).left();
            style = new Label.LabelStyle(style);
            style.fontColor = Color.WHITE;
            Label date = new Label((CharSequence)TimeUtils.shortWithoutYear(apps.getTimeApplication()), style);
            this.add(date).left().width(80.0f);
            btnStyle = new ImageButton.ImageButtonStyle();
            btnStyle.up = assets.getDrawable(atlas, "accept_btn_up");
            btnStyle.down = assets.getDrawable(atlas, "accept_btn_down");
            ImageButton acceptBtn = new ImageButton(btnStyle);
            acceptBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    ClanApplicationsWindow.this.comander.ClanActionTake(apps.getAvatarId());
                    AvatarLine.this.removeFromParentCell();
                }
            });
            this.add(acceptBtn);
        }

        public void removeFromParentCell() {
            Table table = (Table)this.getParent();
            Cell<AvatarLine> cell = table.getCell(this);
            table.getCells().removeValue(cell, true);
            cell.clearActor();
        }
    }
}

