/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.clan;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.massage.MessageWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.net.DataConverter;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.GuildStorage;
import packet.Clan;
import packet.Static;

public class ClanInfoView
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private final TextureAtlas elements = (TextureAtlas)this.assets.get("entity/entity_elements.atlas");
    private final Color nameColor = Color.valueOf("#F0E9CF");
    private final Color numColor = Color.valueOf("#EFD774");
    private final AvatarData master = new AvatarData();
    private final Label name;
    private final Image guild;
    private final Image treasureMap;
    private final ImageButton messageBtn;
    private final Label wins;
    private final Label defeats;
    private final Label draws;
    private final Label escapes;
    private final Label winStreak;
    private final Label clanName;
    private final Label clanSize;
    private final Label clanRating;
    private final Label clanCoffers;
    private final Label clanPrice;
    private Label clanDesc;
    private Image avatarImage;
    private Table nameTable;
    private Clan.ClanDto clan;

    public ClanInfoView(boolean showAppBtn) {
        this.setBackground(this.assets.getNinePatchDrawable(this.assets.getWindowAtlas(), "content_background", 12, 12, 5, 10));
        Table content = new Table();
        content.defaults().space(10.0f);
        this.add(new ScrollPane((Actor)content)).height(354.0f).expand().top();
        Label.LabelStyle labelStyle = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.valueOf("#EFD774"));
        Label title = new Label((CharSequence)this.model.lang.get("window.clans.master"), labelStyle);
        content.add(title).colspan(2).row();
        Table profile = new Table();
        profile.defaults().space(6.0f);
        content.add(profile);
        TextureAtlas atlas = this.assets.getCommonAtlas();
        this.nameTable = new Table();
        Label.LabelStyle nameStyle = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
        this.name = new Label((CharSequence)"", nameStyle);
        this.nameTable.add(this.name).expand().top();
        profile.add(this.nameTable).width(146.0f).expand().top().row();
        this.avatarImage = new Image();
        Stack stack = new Stack(this.avatarImage);
        Table table = new Table();
        this.guild = new Image();
        this.treasureMap = new Image();
        table.add(this.treasureMap).expand().top().left().padLeft(-18.0f).padTop(-10.0f);
        table.add(this.guild).expand().top().right().padRight(-1.0f).padTop(-1.0f).row();
        table.add();
        ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = this.assets.getDrawable(atlas, "message_btn0001");
        btnStyle.down = this.assets.getDrawable(atlas, "message_btn0003");
        this.messageBtn = new ImageButton(btnStyle);
        table.add(this.messageBtn).expand().bottom().right().padRight(-14.0f).padBottom(-12.0f).row();
        this.messageBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WindowManager.getInstance().open(new MessageWindow(ClanInfoView.this.master.name), true);
            }
        });
        stack.add(table);
        profile.add(stack).expand().top().center().padTop(10.0f).padBottom(16.0f).row();
        if (showAppBtn) {
            TextButton.TextButtonStyle appBtnStyle = new TextButton.TextButtonStyle();
            appBtnStyle.up = this.assets.getNinePatchDrawable(atlas, "clan_red_btn_up", 5, 5, 2, 2);
            appBtnStyle.down = this.assets.getNinePatchDrawable(atlas, "clan_red_btn_down", 5, 5, 2, 2);
            appBtnStyle.font = this.assets.getFont().arial14;
            appBtnStyle.fontColor = Color.WHITE;
            appBtnStyle.downFontColor = Color.WHITE.cpy();
            appBtnStyle.downFontColor.a = 0.8f;
            TextButton sendAppBtn = new TextButton(this.model.lang.get("window.clans.send_app"), appBtnStyle);
            sendAppBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    Commander.getInstance().ClanActionApplication(ClanInfoView.this.clan.getTag());
                    WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.confirm.clan_app", "window.confirm.clan_app.message", "window.confirm.ok");
                    WindowManager.getInstance().open(wnd, true);
                }
            });
            profile.add(sendAppBtn);
        }
        Table stats = new Table();
        stats.defaults().space(6.0f);
        this.wins = this.addStatField(stats, this.model.lang.get("window.profile.wins"), 0, this.numColor);
        this.defeats = this.addStatField(stats, this.model.lang.get("window.profile.defeats"), 0, this.numColor);
        this.draws = this.addStatField(stats, this.model.lang.get("window.profile.draws"), 0, this.numColor);
        this.escapes = this.addStatField(stats, this.model.lang.get("window.profile.escapes"), 0, this.numColor);
        this.winStreak = this.addStatField(stats, this.model.lang.get("window.profile.win_streak"), 0, this.numColor);
        content.add(stats).expand().fill().bottom().row();
        Label clanInfo = new Label((CharSequence)this.model.lang.get("window.clans.info"), labelStyle);
        content.add(clanInfo).colspan(2).row();
        Table clanStats = new Table();
        clanStats.defaults().space(6.0f);
        this.clanName = this.addStatField(clanStats, this.model.lang.get("window.clans.name"), "", this.numColor);
        this.clanSize = this.addStatField(clanStats, this.model.lang.get("window.clans.size"), 0, this.numColor);
        this.clanRating = this.addStatField(clanStats, this.model.lang.get("window.clans.rating"), 0, this.numColor);
        this.clanCoffers = this.addStatField(clanStats, this.model.lang.get("window.clans.coffers"), 0, this.numColor);
        this.clanPrice = this.addStatField(clanStats, this.model.lang.get("window.clans.price"), 0, this.numColor);
        content.add(clanStats).colspan(2).growX().row();
        Label.LabelStyle descStyle = new Label.LabelStyle(this.assets.getFont().arialBold14, this.nameColor);
        this.clanDesc = new Label((CharSequence)"", descStyle);
        this.clanDesc.setWrap(true);
        content.add(this.clanDesc).colspan(2).width(320.0f).expand().top().left();
    }

    private Label addStatField(Table table, String name, Object value, Color color) {
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arial14, this.nameColor);
        Label text = new Label((CharSequence)name, style);
        table.add(text).expandX().fillX().left();
        Label.LabelStyle numStyle = new Label.LabelStyle(this.assets.getFont().arialBold14, color);
        Label num = new Label((CharSequence)String.valueOf(value), numStyle);
        num.setAlignment(16);
        table.add(num).expandX().right().row();
        return num;
    }

    public void update(Clan.ClanDto clan) {
        this.clan = clan;
        DataConverter.fromAvatarDto(this.master, clan.getMaster());
        TextureAtlas atlas = this.assets.getCommonAtlas();
        Static.StaticFaction fraction = this.storage.faction.get(this.master.fractionId);
        boolean isOseon = this.storage.faction.isOseon(fraction.getCode());
        String nameBack = isOseon ? "fraction_back0001" : "fraction_back0002";
        this.nameTable.setBackground(this.assets.getNinePatchDrawable(atlas, nameBack, 15, 15, 0, 4));
        String iconName = this.master.getImageName() + "_icon";
        this.avatarImage.setDrawable(this.assets.getDrawable(atlas, iconName));
        this.name.setText(clan.getTag() + "." + this.master.getFullName());
        if (this.master.hasGuild()) {
            Static.StaticGuildRank rank = this.storage.guildRanks.get(this.master.guildRankId);
            int frame = GuildStorage.getGuildRankFrame(rank);
            TextureRegion guildTexture = this.assets.extractRegions(this.elements, "guild_icon").get(frame);
            guildTexture.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.guild.setDrawable(new TextureRegionDrawable(guildTexture));
            this.guild.setScale(0.85f);
        } else {
            this.guild.setDrawable(null);
        }
        if (this.master.treasureId > 0L) {
            this.treasureMap.setDrawable(this.assets.getDrawable(this.elements, "treasure_map_icon"));
        }
        this.wins.setText(String.valueOf(this.master.wins));
        this.defeats.setText(String.valueOf(this.master.defeats));
        this.draws.setText(String.valueOf(this.master.draws));
        this.escapes.setText(String.valueOf(this.master.escape));
        this.winStreak.setText(String.valueOf(this.master.winsStreak));
        this.clanName.setText(clan.getName());
        this.clanSize.setText(String.valueOf(clan.getSize()));
        this.clanCoffers.setText(String.valueOf(clan.getCoffers()));
        this.clanPrice.setText(String.valueOf(clan.getEnterPrice()));
        this.clanRating.setText(String.valueOf(clan.getRating()));
        this.clanDesc.setText(clan.getDescription());
    }
}

