/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.clan;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import packet.Base;
import packet.Clan;
import packet.Transport;

public class ClanInvitationsWindow
extends DefaultWindow
implements MessageListener {
    private final WindowManager windowManager = WindowManager.getInstance();
    private Table main;
    private Array<Clan.ClanInvitationDto> invitationlist;

    public ClanInvitationsWindow(Clan.ClanInvitationList clanInvitationList) {
        super("");
        this.invitationlist = new Array(clanInvitationList.getInvsCount());
        for (int i = 0; i < clanInvitationList.getInvsCount(); ++i) {
            this.invitationlist.add(clanInvitationList.getInvs(i));
        }
    }

    public ClanInvitationsWindow(Array<Clan.ClanInvitationDto> list) {
        super("");
        this.invitationlist = list;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.clan_invitations"));
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).expand().fillX().top().pad(10.0f, 20.0f, 10.0f, 20.0f);
        TextureAtlas atlas = assets.getCommonAtlas();
        TextField.TextFieldStyle textInputStyle = new TextField.TextFieldStyle();
        textInputStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        textInputStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
        textInputStyle.font = ClanInvitationsWindow.assets.getFont().arialBold14;
        textInputStyle.fontColor = Color.WHITE;
        final TextField clanTag = new TextField("", textInputStyle);
        clanTag.setAlignment(1);
        clanTag.setMaxLength(3);
        clanTag.setMessageText(this.model.lang.get("window.clans.tag"));
        Container<Image> bottomLine = new Container<Image>(new Image(assets.getDrawable(atlas, "search_clan_line")));
        bottomLine.getActor().getColor().a = 0.5f;
        bottomLine.bottom().padBottom(-4.0f).fillX();
        this.main.add(new Stack(bottomLine, clanTag)).padBottom(14.0f).padTop(10.0f).top().expand();
        TextButton.TextButtonStyle btnStyle = new TextButton.TextButtonStyle();
        btnStyle.up = assets.getNinePatchDrawable(atlas, "simple_btn_up", 4, 4, 2, 2);
        btnStyle.down = assets.getNinePatchDrawable(atlas, "simple_btn_down", 4, 4, 2, 2);
        btnStyle.font = ClanInvitationsWindow.assets.getFont().arialBold14;
        btnStyle.fontColor = Color.WHITE;
        TextButton sendBtn = new TextButton(this.model.lang.get("window.clan_invitations.send"), btnStyle);
        sendBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ClanInvitationsWindow.this.comander.ClanActionApplication(clanTag.getText().trim());
                ((ClanInvitationsWindow)ClanInvitationsWindow.this).soundSystem.fx.play("sound/fx/24. Join_guild.mp3");
                clanTag.setText("");
            }
        });
        this.main.add(sendBtn).expandX().row();
        Table list = new Table();
        list.defaults().space(6.0f);
        for (Clan.ClanInvitationDto inv : this.invitationlist) {
            list.add(new InvitationLine(inv)).growX().row();
        }
        ScrollPane scrollPane = new ScrollPane((Actor)list);
        Table container = new Table();
        container.setBackground(assets.getNinePatchDrawable(atlas, "message_text_bg", 6, 6, 4, 4));
        container.add(scrollPane).growX().expandY().top();
        this.main.add(container).colspan(2).height(200.0f).grow();
        this.model.addListener(this, Cmd.Error.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case Error: {
                Base.ErrorMsg errorMsg = Base.ErrorMsg.parseFrom(msg.getData());
                if (errorMsg.getCode() == 313) {
                    WarningWindow window = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", "window.error.clan_invitations.message", "window.error.clan_search.answer");
                    this.windowManager.open(window, true);
                    break;
                }
                if (errorMsg.getCode() != 315) break;
                WarningWindow window = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", "window.error.clan_invitations.join_fail", "window.error.clan_search.answer");
                this.windowManager.open(window, true);
                break;
            }
        }
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }

    class InvitationLine
    extends Table {
        public InvitationLine(final Clan.ClanInvitationDto inv) {
            this.defaults().space(6.0f);
            TextureAtlas atlas = assets.getCommonAtlas();
            this.setBackground(assets.getDrawable(atlas, "clan_line_bg"));
            this.padLeft(6.0f).padRight(6.0f);
            ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
            btnStyle.up = assets.getDrawable(atlas, "reject_btn_up");
            btnStyle.down = assets.getDrawable(atlas, "reject_btn_down");
            ImageButton rejectBtn = new ImageButton(btnStyle);
            rejectBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    ClanInvitationsWindow.this.comander.ClanDeleteInvitation(inv.getId());
                    InvitationLine.this.removeFromParentCell();
                }
            });
            this.add(rejectBtn);
            String color = ((ClanInvitationsWindow)ClanInvitationsWindow.this).storage.faction.getColor(((ClanInvitationsWindow)ClanInvitationsWindow.this).model.player.selectedAvatar.fractionId);
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.valueOf(color));
            String text = String.format("[%s] %s", inv.getTag(), inv.getClanName());
            Label name = new Label((CharSequence)text, style);
            name.setEllipsis(true);
            this.add(name).width(126.0f).left();
            style = new Label.LabelStyle(style);
            style.fontColor = Color.WHITE;
            Label date = new Label((CharSequence)TimeUtils.shortWithoutYear(inv.getInvitationTime()), style);
            this.add(date).left().width(80.0f);
            Image energyIcon = new Image(assets.getDrawable(atlas, "energy_icon_small"));
            this.add(energyIcon).right();
            Label entryPrice = new Label((CharSequence)String.valueOf(inv.getEntryPrice()), style);
            this.add(entryPrice).left().expand();
            btnStyle = new ImageButton.ImageButtonStyle();
            btnStyle.up = assets.getDrawable(atlas, "accept_btn_up");
            btnStyle.down = assets.getDrawable(atlas, "accept_btn_down");
            ImageButton acceptBtn = new ImageButton(btnStyle);
            acceptBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((ClanInvitationsWindow)ClanInvitationsWindow.this).model.player.selectedAvatar.clanId > 0L) {
                        WarningWindow window = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", "window.error.clan_invitations.in_clan", "window.error.clan_search.answer");
                        ClanInvitationsWindow.this.windowManager.open(window, true);
                        return;
                    }
                    ClanInvitationsWindow.this.comander.ClanActionJoin(inv.getClanId());
                    InvitationLine.this.removeFromParentCell();
                }
            });
            this.add(acceptBtn);
        }

        public void removeFromParentCell() {
            Table table = (Table)this.getParent();
            Cell<InvitationLine> cell = table.getCell(this);
            table.getCells().removeValue(cell, true);
            cell.clearActor();
        }
    }
}

