/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.clan;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.clan.ClanInfoView;
import com.tpwar.game.windows.clan.NewClanWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import packet.Base;
import packet.Clan;
import packet.Transport;

public class ClanTopWindow
extends DefaultWindow
implements MessageListener {
    private final WindowManager windowManager = WindowManager.getInstance();
    private Table main;
    private Clan.ClanList clanList;
    private ClanInfoView clanInfoView;

    public ClanTopWindow(Clan.ClanList clanList) {
        super("");
        this.clanList = clanList;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.clans"));
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).expand().pad(10.0f, 20.0f, 10.0f, 20.0f);
        Table left = new Table();
        left.defaults().space(6.0f);
        ClanListView clanListView = new ClanListView(new SelectClanListener(){

            @Override
            public void selected(Clan.ClanDto clan) {
                if (ClanTopWindow.this.clanInfoView != null) {
                    ClanTopWindow.this.clanInfoView.update(clan);
                }
            }
        });
        clanListView.buttonGroup.setMaxCheckCount(0);
        left.add(clanListView).row();
        TextureAtlas atlas = assets.getCommonAtlas();
        TextButton.TextButtonStyle createBtnStyle = new TextButton.TextButtonStyle();
        createBtnStyle.up = assets.getNinePatchDrawable(atlas, "clan_red_btn_up", 5, 5, 4, 4);
        createBtnStyle.down = assets.getNinePatchDrawable(atlas, "clan_red_btn_down", 5, 5, 4, 4);
        createBtnStyle.font = ClanTopWindow.assets.getFont().arialBold14;
        createBtnStyle.fontColor = Color.WHITE;
        createBtnStyle.downFontColor = Color.WHITE.cpy();
        createBtnStyle.downFontColor.a = 0.8f;
        TextButton createBtn = new TextButton(this.model.lang.get("window.clans.create_new"), createBtnStyle);
        createBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (((ClanTopWindow)ClanTopWindow.this).model.player.selectedAvatar.level < 2) {
                    WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.confirm.clan_app", "window.error.new_clan.level", "window.error.new_clan.answer");
                    ClanTopWindow.this.windowManager.open(wnd, true);
                } else {
                    ClanTopWindow.this.windowManager.open(new NewClanWindow(), true);
                }
            }
        });
        left.add(createBtn).growX();
        Table right = new Table();
        this.clanInfoView = new ClanInfoView(true);
        right.add(this.clanInfoView).expand().top();
        if (this.clanList.getClansCount() > 0) {
            clanListView.buttonGroup.setMaxCheckCount(1);
            this.clanInfoView.update(this.clanList.getClans(0));
        }
        this.main.add(left).expand().top();
        this.main.add(right).expand().top();
        this.model.addListener(this, Cmd.Error.getCode());
        this.model.addListener(this, Cmd.ClanSearchResult.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case Error: {
                Base.ErrorMsg error = Base.ErrorMsg.parseFrom(msg.getData());
                if (error.getCode() != 320) break;
                WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.error.clan_search", "window.error.clan_search.message", "window.error.clan_search.answer");
                this.windowManager.open(wnd, true);
                break;
            }
            case ClanSearchResult: {
                this.clanInfoView.update(Clan.ClanDto.parseFrom(msg.getData()));
                break;
            }
        }
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
        this.model.removeListeners(this);
    }

    class ClanListView
    extends Table {
        public ButtonGroup<ClanView> buttonGroup = new ButtonGroup();

        public ClanListView(final SelectClanListener listener) {
            this.setBackground(assets.getNinePatchDrawable(assets.getWindowAtlas(), "content_background", 6, 6, 5, 5));
            this.defaults().space(6.0f);
            Label.LabelStyle labelStyle = new Label.LabelStyle(assets.getFont().arialBold14, Color.valueOf("#EFD774"));
            Label title = new Label((CharSequence)((ClanTopWindow)ClanTopWindow.this).model.lang.get("window.clans.top"), labelStyle);
            this.add(title).row();
            Table container = new Table();
            container.defaults().space(6.0f);
            Table scroll = new Table();
            scroll.add(new ScrollPane((Actor)container)).expandY().top();
            this.add(scroll).size(150.0f, 270.0f).expand().top().row();
            for (int i = 0; i < ClanTopWindow.this.clanList.getClansCount(); ++i) {
                final Clan.ClanDto clan = ClanTopWindow.this.clanList.getClans(i);
                ClanView clanBtn = new ClanView(clan, i + 1);
                clanBtn.addListener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        super.clicked(event, x, y);
                        listener.selected(clan);
                    }
                });
                this.buttonGroup.add(clanBtn);
                container.add(clanBtn).row();
            }
            Table searchTable = new Table();
            TextureAtlas atlas = assets.getCommonAtlas();
            TextField.TextFieldStyle textInputStyle = new TextField.TextFieldStyle();
            textInputStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
            textInputStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
            textInputStyle.font = assets.getFont().arialBold14;
            textInputStyle.fontColor = Color.WHITE;
            final TextField inputClanTag = new TextField("", textInputStyle);
            inputClanTag.setMessageText(((ClanTopWindow)ClanTopWindow.this).model.lang.get("window.clans.tag"));
            searchTable.add(inputClanTag).width(130.0f);
            inputClanTag.setTextFieldListener(new TextField.TextFieldListener(){

                @Override
                public void keyTyped(TextField textField, char c) {
                    if (c == '\r' || c == '\n') {
                        ClanTopWindow.this.comander.ClanActionSearch(textField.getText());
                        Gdx.input.setOnscreenKeyboardVisible(false);
                    }
                }
            });
            ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
            btnStyle.up = assets.getDrawable(atlas, "search_clan_btn_up");
            btnStyle.down = assets.getDrawable(atlas, "search_clan_btn_down");
            ImageButton searchBtn = new ImageButton(btnStyle);
            searchTable.add(searchBtn);
            searchBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    ClanTopWindow.this.comander.ClanActionSearch(inputClanTag.getText());
                    Gdx.input.setOnscreenKeyboardVisible(false);
                }
            });
            Container<Image> bottomLine = new Container<Image>(new Image(assets.getDrawable(atlas, "search_clan_line")));
            bottomLine.getActor().getColor().a = 0.5f;
            bottomLine.bottom().padBottom(-4.0f).fillX();
            this.add(new Stack(bottomLine, searchTable)).padBottom(6.0f).padTop(5.0f).row();
        }
    }

    static interface SelectClanListener {
        public void selected(Clan.ClanDto var1);
    }

    static class ClanView
    extends Button {
        public ClanView(Clan.ClanDto clan, int position) {
            TextureAtlas atlas = assets.getCommonAtlas();
            Button.ButtonStyle style = new Button.ButtonStyle();
            style.up = assets.getDrawable(atlas, "clan_tab_up");
            style.checked = assets.getDrawable(atlas, "clan_tab_down");
            this.setStyle(style);
            Label.LabelStyle nameStyle = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
            String text = String.format("%d. [%s] %s", position, clan.getTag(), clan.getName());
            Label name = new Label((CharSequence)text, nameStyle);
            name.setEllipsis(true);
            this.add(name).width(142.0f).height(30.0f).fill().padLeft(4.0f);
        }
    }
}

