/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.clan;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.clan.ClanApplicationsWindow;
import com.tpwar.game.windows.clan.ClanExcludeWindow;
import com.tpwar.game.windows.clan.ClanExitWindow;
import com.tpwar.game.windows.clan.ClanInfoView;
import com.tpwar.game.windows.clan.EditClanSloganWindow;
import com.tpwar.game.windows.massage.MessageWindow;
import com.tpwar.game.windows.rating.RatingLine;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import packet.Clan;
import packet.Transport;

public class ClanWindow
extends DefaultWindow
implements MessageListener {
    private final WindowManager windowManager = WindowManager.getInstance();
    private Clan.ClanDto clan;
    private Table main;
    private ClanInfoView clanInfoView;
    private ClanTopView clanTopView;
    private Table right;

    public ClanWindow(Clan.ClanDto clan) {
        super("");
        this.clan = clan;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.clans"));
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).expand().fillY().top().pad(10.0f, 20.0f, 10.0f, 20.0f);
        Table left = new Table();
        left.defaults().space(6.0f);
        left.add(this.menu()).expandY().top();
        this.right = new Table();
        this.clanInfoView = new ClanInfoView(false);
        this.right.add(this.clanInfoView).expand().top();
        this.clanInfoView.update(this.clan);
        this.main.add(left).expand().fillY().top();
        this.main.add(this.right).expand().fillY().top();
        this.clanTopView = new ClanTopView(this.clan);
        this.model.addListener(this, Cmd.ClanApplicationList.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case ClanApplicationList: {
                this.windowManager.open(new ClanApplicationsWindow(Clan.ClanApplicationList.parseFrom(msg.getData())), true);
                break;
            }
        }
    }

    private Table menu() {
        Table table = new Table();
        table.defaults().space(6.0f);
        TextureAtlas atlas = assets.getCommonAtlas();
        TextButton.TextButtonStyle btnStyle = new TextButton.TextButtonStyle();
        btnStyle.up = assets.getNinePatchDrawable(atlas, "simple_btn_up", 4, 4, 2, 2);
        btnStyle.down = assets.getNinePatchDrawable(atlas, "simple_btn_down", 4, 4, 2, 2);
        btnStyle.font = ClanWindow.assets.getFont().arialBold14;
        btnStyle.fontColor = Color.WHITE;
        TextButton writeBtn = new TextButton(this.model.lang.get("window.clan.write"), btnStyle);
        writeBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MessageWindow wnd = new MessageWindow();
                wnd.setMessageType("clan_message");
                ClanWindow.this.windowManager.open(wnd, true);
            }
        });
        table.add(writeBtn).row();
        final TextButton topBtn = new TextButton(this.model.lang.get("window.clan.top"), btnStyle);
        topBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ClanWindow.this.clanInfoView.hasParent()) {
                    ClanWindow.this.right.reset();
                    topBtn.setText(((ClanWindow)ClanWindow.this).model.lang.get("window.clan.info"));
                    ClanWindow.this.right.add(ClanWindow.this.clanTopView).width(344.0f).growY();
                } else {
                    ClanWindow.this.right.reset();
                    topBtn.setText(((ClanWindow)ClanWindow.this).model.lang.get("window.clan.top"));
                    ClanWindow.this.right.add(ClanWindow.this.clanInfoView).width(344.0f);
                }
            }
        });
        table.add(topBtn).row();
        TextButton allClansBtn = new TextButton(this.model.lang.get("window.clan.all_clans"), btnStyle);
        allClansBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ClanWindow.this.comander.GetClanList();
                ClanWindow.this.closeHandler();
            }
        });
        table.add(allClansBtn).row();
        TextButton exitBtn = new TextButton(this.model.lang.get("window.clan.leave"), btnStyle);
        exitBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (((ClanWindow)ClanWindow.this).model.player.selectedAvatar.isClanMaster()) {
                    ClanWindow.this.windowManager.open(new ClanExitWindow(), true);
                } else {
                    final WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.confirm.clan_exit", "window.confirm.clan_exit.message", "window.confirm.clan_exit.answer");
                    wnd.setActionlistener(new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            ClanWindow.this.comander.ClanActionLeave();
                            wnd.closeHandler();
                            ClanWindow.this.closeHandler();
                        }
                    });
                    ClanWindow.this.windowManager.open(wnd, true);
                }
            }
        });
        table.add(exitBtn).row();
        if (this.model.player.selectedAvatar.isClanMaster()) {
            TextButton appBtn = new TextButton(this.model.lang.get("window.clan.app"), btnStyle);
            appBtn.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    ClanWindow.this.comander.GetClanApplicationList();
                }
            });
            table.add(appBtn).row();
            TextButton excludeBtn = new TextButton(this.model.lang.get("window.clan.exclude"), btnStyle);
            excludeBtn.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    ClanWindow.this.windowManager.open(new ClanExcludeWindow(), true);
                }
            });
            table.add(excludeBtn).row();
            TextButton editBtn = new TextButton(this.model.lang.get("window.clan.edit"), btnStyle);
            editBtn.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    ClanWindow.this.windowManager.open(new EditClanSloganWindow(ClanWindow.this.clan, new EditClanSloganWindow.ChangeSloganListener(){

                        @Override
                        public void change(String newSlogan, boolean autoApproval) {
                            Clan.ClanDto.Builder clanBuilder = ClanWindow.this.clan.toBuilder();
                            clanBuilder.setDescription(newSlogan);
                            clanBuilder.setAutoApproval(autoApproval);
                            ClanWindow.this.clan = clanBuilder.build();
                            ClanWindow.this.clanInfoView.update(ClanWindow.this.clan);
                        }
                    }), true);
                }
            });
            table.add(editBtn).expandY().bottom().row();
        }
        return table;
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }

    class ClanTopView
    extends Table {
        public ClanTopView(Clan.ClanDto clan) {
            this.defaults().space(10.0f);
            this.setBackground(assets.getNinePatchDrawable(assets.getWindowAtlas(), "content_background", 12, 12, 5, 10));
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.valueOf("#EFD774"));
            Label bestInClan = new Label((CharSequence)((ClanWindow)ClanWindow.this).model.lang.get("window.clan.best_in_clan"), style);
            bestInClan.setAlignment(1);
            this.add(bestInClan).expandX().row();
            Table rating = new Table();
            rating.defaults().space(4.0f);
            for (int i = 0; i < clan.getTopCount(); ++i) {
                Clan.RatingDto ratingDto = clan.getTopList().get(i);
                rating.add(new ClanRatingLine(ratingDto, i + 1)).growX().row();
            }
            ScrollPane scrollRating = new ScrollPane((Actor)rating);
            Container<ScrollPane> ratingContainer = new Container<ScrollPane>(scrollRating);
            ratingContainer.top();
            this.add(ratingContainer).expandY().top();
        }
    }

    class ClanRatingLine
    extends RatingLine {
        public ClanRatingLine(Clan.RatingDto rating, int pos) {
            super(assets);
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
            if (pos <= 3) {
                Image ratingCup = new Image(assets.getDrawable(this.atlas, "rating_cup", pos));
                this.add(new Container<Image>(ratingCup)).width(46.0f);
            } else {
                Label position = new Label((CharSequence)String.valueOf(pos), style);
                position.setAlignment(1);
                this.add(position).width(46.0f).center();
            }
            Label name = new Label((CharSequence)String.format("%s[%d]", rating.getName(), rating.getLevel()), new Label.LabelStyle(style));
            name.getStyle().fontColor = this.colorForFraction(((ClanWindow)ClanWindow.this).model.player.selectedAvatar.fractionId);
            this.add(name).width(170.0f).padLeft(10.0f);
            Label score = new Label((CharSequence)String.valueOf(rating.getScore()), style);
            score.setAlignment(16);
            this.add(score).width(86.0f);
        }
    }
}

