/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.clan;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.tpwar.game.windows.DefaultWindow;
import packet.Clan;

public class EditClanSloganWindow
extends DefaultWindow {
    private Clan.ClanDto clan;
    private Table main;
    private ChangeSloganListener listener;
    private boolean autoApproval;
    private ButtonGroup autoApprovalBtnGroup;

    public EditClanSloganWindow(Clan.ClanDto clan, ChangeSloganListener listener) {
        super("");
        this.clan = clan;
        this.listener = listener;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.edit_clan"));
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).growX().pad(10.0f, 20.0f, 10.0f, 20.0f);
        TextureAtlas atlas = assets.getCommonAtlas();
        TextField.TextFieldStyle textInputStyle = new TextField.TextFieldStyle();
        textInputStyle.background = assets.getNinePatchDrawable(atlas, "message_text_bg", 4, 4, 2, 2);
        textInputStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        textInputStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
        textInputStyle.font = EditClanSloganWindow.assets.getFont().arialBold14;
        textInputStyle.fontColor = Color.WHITE;
        final TextArea slogan = new TextArea(this.clan.getDescription(), textInputStyle);
        slogan.setMaxLength(150);
        this.main.add(slogan).height(110.0f).top().grow().row();
        TextureAtlas windowAtlas = assets.getWindowAtlas();
        TextButton.TextButtonStyle leftBtnStyle = new TextButton.TextButtonStyle();
        leftBtnStyle.checked = assets.getNinePatchDrawable(windowAtlas, "red_radio_btn_on", 4, 0, 0, 0);
        leftBtnStyle.up = assets.getNinePatchDrawable(windowAtlas, "red_radio_btn_off", 4, 0, 0, 0);
        leftBtnStyle.font = EditClanSloganWindow.assets.getFont().arialBold14;
        leftBtnStyle.fontColor = Color.LIGHT_GRAY;
        leftBtnStyle.checkedFontColor = Color.WHITE;
        Label.LabelStyle style = new Label.LabelStyle(EditClanSloganWindow.assets.getFont().arialBold14, Color.WHITE);
        Label autoApprovalLabel = new Label((CharSequence)"\u0410\u0432\u0442\u043e\u043e\u0434\u043e\u0431\u0440\u0435\u043d\u0438\u0435 \u0437\u0430\u044f\u0432\u043e\u043a:", style);
        this.autoApproval = this.clan.getAutoApproval();
        Table buttonTable = new Table();
        buttonTable.add(autoApprovalLabel).colspan(2).padBottom(10.0f).row();
        TextButton onBtn = new TextButton("\u0412\u043a\u043b", leftBtnStyle);
        onBtn.getLabelCell().padLeft(6.0f);
        buttonTable.add(onBtn).width(90.0f);
        TextButton.TextButtonStyle rightBtnStyle = new TextButton.TextButtonStyle(leftBtnStyle);
        rightBtnStyle.checked = assets.getNinePatchDrawable(windowAtlas, "red_right_radio_btn_on", 0, 4, 0, 0);
        rightBtnStyle.up = assets.getNinePatchDrawable(windowAtlas, "red_right_radio_btn_off", 0, 4, 0, 0);
        TextButton offBtn = new TextButton("\u0412\u044b\u043a\u043b", rightBtnStyle);
        offBtn.getLabelCell().padLeft(6.0f);
        buttonTable.add(offBtn).width(90.0f);
        this.autoApprovalBtnGroup = new ButtonGroup((Button[])new TextButton[]{onBtn, offBtn});
        this.autoApprovalBtnGroup.setMinCheckCount(1);
        this.autoApprovalBtnGroup.setChecked(this.autoApproval ? onBtn.getText().toString() : offBtn.getText().toString());
        this.main.add(buttonTable).width(200.0f).expandX().row();
        TextButton actionButton = new TextButton(this.model.lang.get("window.edit_clan.save"), EditClanSloganWindow.assets.getUi().yellowButtonStyle);
        this.getButtonTable().add(actionButton);
        this.getButtonTable().padBottom(6.0f);
        actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String newSlogan = slogan.getText().trim();
                EditClanSloganWindow.this.comander.ClanChangeDescription(newSlogan);
                boolean bl = EditClanSloganWindow.this.autoApproval = EditClanSloganWindow.this.autoApprovalBtnGroup.getCheckedIndex() == 0;
                if (EditClanSloganWindow.this.clan.getAutoApproval() != EditClanSloganWindow.this.autoApproval) {
                    EditClanSloganWindow.this.comander.ClanChangeAutoApproval(EditClanSloganWindow.this.autoApproval);
                }
                EditClanSloganWindow.this.listener.change(newSlogan, EditClanSloganWindow.this.autoApproval);
                EditClanSloganWindow.this.closeHandler();
            }
        });
    }

    static interface ChangeSloganListener {
        public void change(String var1, boolean var2);
    }
}

