/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.clan;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;

public class NewClanWindow
extends DefaultWindow {
    private WindowManager windowManager = WindowManager.getInstance();
    private Table main;

    public NewClanWindow() {
        super("");
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.new_clan"));
        this.main = new Table();
        this.main.defaults().space(10.0f);
        this.getContentTable().add(this.main).expand().pad(10.0f, 20.0f, 10.0f, 20.0f);
        TextureAtlas atlas = assets.getCommonAtlas();
        TextField.TextFieldStyle textInputStyle = new TextField.TextFieldStyle();
        textInputStyle.background = assets.getNinePatchDrawable(atlas, "message_text_bg", 4, 4, 2, 2);
        textInputStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        textInputStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
        textInputStyle.font = NewClanWindow.assets.getFont().arialBold14;
        textInputStyle.messageFont = NewClanWindow.assets.getFont().arial14;
        textInputStyle.fontColor = Color.WHITE;
        Label.LabelStyle style = new Label.LabelStyle(NewClanWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        Label tagText = new Label((CharSequence)this.model.lang.get("window.new_clan.tag"), style);
        this.main.add(tagText).expandX().left();
        final TextField tag = new TextField("", textInputStyle);
        tag.setMaxLength(3);
        this.main.add(tag).width(80.0f).expandX().right().row();
        Label nameText = new Label((CharSequence)this.model.lang.get("window.clans.name"), style);
        this.main.add(nameText).left();
        final TextField name = new TextField("", textInputStyle);
        name.setMaxLength(15);
        this.main.add(name).expandX().right().row();
        Label priceText = new Label((CharSequence)this.model.lang.get("window.new_clan.enter_price"), style);
        this.main.add(priceText).expandX().left();
        Table container = new Table();
        container.defaults().space(6.0f);
        Image energyIcon = new Image(assets.getDrawable(atlas, "energy_icon_small"));
        container.add(energyIcon).expandX().right();
        final TextField price = new TextField("", textInputStyle);
        price.setMaxLength(4);
        price.setMessageText("1-1000");
        price.setTextFieldFilter(new TextField.TextFieldFilter(){

            @Override
            public boolean acceptChar(TextField textField, char c) {
                return Character.toString(c).matches("^[0-9]");
            }
        });
        container.add(price).expandX().right();
        this.main.add(container).expandX().right().row();
        final TextArea slogan = new TextArea("", textInputStyle);
        slogan.setMaxLength(150);
        slogan.setMessageText(this.model.lang.get("window.new_clan.slogan"));
        this.main.add(slogan).growX().height(60.0f).colspan(2).row();
        Label costText = new Label((CharSequence)this.model.lang.get("window.new_clan.price"), style);
        this.main.add(costText).expandX().left();
        container = new Table();
        container.defaults().space(6.0f);
        Image crystalIcon = new Image(assets.getDrawable(atlas, "crystal_icon_small"));
        container.add(crystalIcon).right();
        style = new Label.LabelStyle(style);
        style.fontColor = Color.WHITE;
        style.font = NewClanWindow.assets.getFont().arialBold14;
        Label cost = new Label((CharSequence)String.valueOf(100), style);
        container.add(cost).width(40.0f).right();
        this.main.add(container).expand().right();
        TextButton createBtn = new TextButton(this.model.lang.get("window.new_clan.create"), NewClanWindow.assets.getUi().buyButtonStyle);
        this.getButtonTable().add(createBtn);
        this.getButtonTable().padBottom(6.0f);
        createBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                final String clanTag = tag.getText().trim();
                if (clanTag.length() < 2) {
                    NewClanWindow.this.showError("window.error.new_clan.tag");
                    return;
                }
                final String clanName = name.getText().trim();
                if (clanName.length() < 3) {
                    NewClanWindow.this.showError("window.error.new_clan.name");
                    return;
                }
                int parsePrice = 0;
                try {
                    parsePrice = Integer.parseInt(price.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (parsePrice < 1 || parsePrice > 1000) {
                    NewClanWindow.this.showError("window.error.new_clan.price");
                    return;
                }
                final int clanPrice = parsePrice;
                final String clanSlogan = slogan.getText().trim();
                FinanceManager.showConfirmWindow(((NewClanWindow)NewClanWindow.this).model.lang.format("window.confirm.new_clan.message", 100), new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        WindowManager.getInstance().closeCurrentWindow();
                        NewClanWindow.this.comander.ClanActionCreate(clanTag, clanName, clanPrice, clanSlogan);
                        ((NewClanWindow)NewClanWindow.this).soundSystem.fx.play("sound/fx/3. Buy.mp3");
                    }
                });
            }
        });
    }

    private void showError(String messageKey) {
        WarningWindow wnd = WarningWindow.create(WarningWindow.Type.WARNING, "window.error", messageKey, "window.error.new_clan.answer");
        this.windowManager.open(wnd, true);
    }
}

