/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.daily;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.game.windows.DefaultWindow;
import java.util.List;
import packet.Avatars;
import packet.Static;

public class DailyBonusWindow
extends DefaultWindow {
    private final Avatars.DailyBonusData dailyBonus;

    public DailyBonusWindow(Avatars.DailyBonusData dailyBonus) {
        super("\u0415\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u044b\u0439 \u0431\u043e\u043d\u0443\u0441");
        this.dailyBonus = dailyBonus;
    }

    @Override
    public void openHandler() {
        BonusCard nextBonus;
        BonusCard prevBonus;
        this.soundSystem.fx.play("sound/fx/23. Successfull_mine, dig, pryanik.mp3");
        List<Static.StaticDailyBonus> bonuses = this.storage.bonus.getAll();
        Static.StaticDailyBonus current = this.storage.bonus.get(this.dailyBonus.getBonusId());
        int index = bonuses.indexOf(current);
        TextureAtlas atlas = assets.getCommonAtlas();
        TextureAtlas.AtlasRegion arrowRegion = atlas.findRegion("daily_bonus_arrow");
        Table bonusSetout = new Table();
        bonusSetout.defaults().space(6.0f);
        if (index == bonuses.size() - 1) {
            prevBonus = new BonusCard(bonuses.get(index - 2));
            prevBonus.setScale(0.9f);
            bonusSetout.add(prevBonus);
            bonusSetout.add(new Image(arrowRegion));
        }
        if (index > 0) {
            prevBonus = new BonusCard(bonuses.get(index - 1));
            prevBonus.setScale(0.9f);
            bonusSetout.add(prevBonus);
            bonusSetout.add(new Image(arrowRegion));
        }
        bonusSetout.add(new BonusCard(current));
        if (index < bonuses.size() - 1) {
            bonusSetout.add(new Image(arrowRegion));
            nextBonus = new BonusCard(bonuses.get(index + 1));
            nextBonus.setScale(0.9f);
            bonusSetout.add(nextBonus).padLeft(6.0f);
        }
        if (index == 0) {
            bonusSetout.add(new Image(arrowRegion));
            nextBonus = new BonusCard(bonuses.get(index + 2));
            nextBonus.setScale(0.9f);
            bonusSetout.add(nextBonus).padLeft(6.0f);
        }
        Label.LabelStyle style = new Label.LabelStyle(DailyBonusWindow.assets.getFont().arial14, Color.WHITE);
        Label description = new Label((CharSequence)this.model.lang.get("bonus.daily"), style);
        description.setAlignment(1);
        description.setWrap(true);
        Table main = new Table();
        main.defaults().space(10.0f);
        main.add(bonusSetout).expand().row();
        main.add(description).width(300.0f).padBottom(6.0f);
        this.getContentTable().add(main).expand().padLeft(20.0f).padRight(20.0f).padTop(6.0f).padBottom(6.0f).row();
    }

    private class BonusCard
    extends Stack {
        public BonusCard(Static.StaticDailyBonus staticDailyBonus) {
            this.setTransform(true);
            DailyBonusWindow.this.align(1);
            TextureAtlas atlas = assets.getCommonAtlas();
            TextureAtlas.AtlasRegion region = atlas.findRegion("daily_bonus");
            region.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Image image = new Image(region);
            Container<Image> background = new Container<Image>(image);
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold14, Color.WHITE);
            Label day = new Label((CharSequence)("\u0414\u0435\u043d\u044c " + staticDailyBonus.getDay()), style);
            region = atlas.findRegion("energy_icon_small");
            region.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Image energyIcon = new Image(region);
            Label energy = new Label((CharSequence)("+" + staticDailyBonus.getEnergy()), style);
            Table info = new Table();
            info.add(day).top().row();
            HorizontalGroup bonus = new HorizontalGroup();
            bonus.space(6.0f);
            bonus.addActor(energyIcon);
            bonus.addActor(energy);
            info.add(bonus).expand().bottom();
            this.add(background);
            this.add(info);
        }

        @Override
        public float getPrefWidth() {
            return this.getScaleX() * super.getPrefWidth();
        }

        @Override
        public float getPrefHeight() {
            return this.getScaleY() * super.getPrefHeight();
        }
    }
}

