/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.exchanger;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Colors;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import java.util.List;
import packet.Static;

public class ExchangerWindow
extends DefaultWindow {
    private final WindowManager windowManager = WindowManager.getInstance();
    private ShaderProgram shader;

    public ExchangerWindow() {
        super("\u041e\u0431\u043c\u0435\u043d\u043d\u0438\u043a");
    }

    @Override
    public void openHandler() {
        this.shader = (ShaderProgram)assets.get("tint_shader");
        Table main = new Table();
        main.defaults().space(6.0f);
        main.setBackground(assets.getNinePatchDrawable(assets.getWindowAtlas(), "content_background", 10, 10, 10, 10));
        this.getContentTable().add(main).growX().pad(20.0f, 20.0f, 10.0f, 20.0f);
        List<Static.StaticExchangerPosition> all = this.storage.exchanger.getAll();
        for (Static.StaticExchangerPosition sep : all) {
            main.add(new ExchangerPosition(sep)).growX().row();
        }
    }

    @Override
    public void closeHandler() {
        super.closeHandler();
    }

    class ExchangerPosition
    extends Button {
        public ExchangerPosition(final Static.StaticExchangerPosition sep) {
            this.defaults().space(10.0f);
            TextureAtlas commonAtlas = assets.getCommonAtlas();
            Button.ButtonStyle buttonStyle = new Button.ButtonStyle();
            buttonStyle.up = assets.getDrawable(commonAtlas, "exchanger_pos");
            this.setStyle(buttonStyle);
            this.pad(4.0f);
            Label.LabelStyle style = new Label.LabelStyle(assets.getFont().arialBold16, Color.WHITE);
            Label price = new Label((CharSequence)String.valueOf(sep.getCrystals()), style);
            price.setAlignment(16);
            this.add(price).width(32.0f).right();
            Image crystalIcon = new Image(commonAtlas.findRegion("crystal_icon"));
            this.add(crystalIcon);
            Image arrow = new Image(commonAtlas.findRegion("exchanger_arrow"));
            this.add(arrow);
            Table energyTable = new Table();
            Label energy = new Label((CharSequence)String.valueOf(sep.getCrystals()), new Label.LabelStyle(style));
            energy.getStyle().fontColor = Colors.ENERGY_COLOR;
            energyTable.add(energy).expandX().right().row();
            if (sep.getEnergy() > sep.getCrystals()) {
                style = new Label.LabelStyle(assets.getFont().arial14, Colors.ENERGY_COLOR);
                Label extraEnergy = new Label((CharSequence)("+" + (sep.getEnergy() - sep.getCrystals())), style);
                energyTable.add(extraEnergy).expandX().right();
            }
            this.add(energyTable).width(36.0f).right();
            Image energyIcon = new Image(commonAtlas.findRegion("energy_icon"));
            this.add(energyIcon);
            this.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (FinanceManager.checkCrystals(((ExchangerWindow)ExchangerWindow.this).model.player, sep.getCrystals())) {
                        FinanceManager.showConfirmWindow(sep.getCrystals(), new ClickListener(){

                            @Override
                            public void clicked(InputEvent event, float x, float y) {
                                ExchangerWindow.this.comander.ExchangeEnergyRequest(sep.getId());
                                ((ExchangerWindow)ExchangerWindow.this).soundSystem.fx.play("sound/fx/29. Exchange_crystal_to_energy.mp3");
                                ExchangerWindow.this.windowManager.closeCurrentWindow();
                            }
                        });
                    }
                }
            });
        }

        @Override
        public void draw(Batch batch, float parentAlpha) {
            if (this.isPressed()) {
                batch.setShader(ExchangerWindow.this.shader);
                ExchangerWindow.this.shader.setUniformf("u_color", Color.LIGHT_GRAY);
            }
            super.draw(batch, parentAlpha);
            batch.setShader(null);
        }
    }
}

