/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.gate;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.BuildingData;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.StringUtils;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.action.AvatarSlotWithButton;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.Storage;
import com.tpwar.storage.fraction.FractionStorage;
import com.tpwar.storage.planet.PlanetData;
import java.util.concurrent.TimeUnit;
import packet.Static;
import packet.Transport;

public class GateWindow
extends DefaultWindow
implements MessageListener {
    private Storage storage = Storage.getInstance();
    private TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
    private Static.StaticBuilding data;
    private BuildingData buildingData;
    private Image buildingIcon;
    private AvatarSlotWithButton avatarSlot;
    private TextButton actionBtn;
    private TextButton teleportBtn;
    private Label decription;
    private Label timerText;
    private boolean timerActive = false;
    private float timerDelta = 0.0f;
    private Table leftSide;
    private Table rightSide;
    private Container<Actor> slotContainer;
    private Label occupationText;

    public GateWindow(Static.StaticBuilding data) {
        super("");
        this.data = data;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.gate"));
        Table main = new Table();
        main.defaults().space(10.0f);
        this.getContentTable().add(main).expand().pad(10.0f, 20.0f, 10.0f, 20.0f);
        this.leftSide = new Table();
        this.rightSide = new Table();
        main.add(this.leftSide);
        main.add(this.rightSide).fill().top();
        this.slotContainer = new Container();
        this.leftSide.add(this.slotContainer).size(170.0f, 275.0f);
        this.buildingData = this.model.zone.getBuildingData(this.data.getId());
        this.buildingIcon = Component.getImage(this.atlas, "building_gate");
        Label.LabelStyle descriptionStyle = new Label.LabelStyle(GateWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        final AvatarData avatar = this.model.player.selectedAvatar;
        Object text = null;
        if (this.data.getFactionId() == avatar.fractionId) {
            energy = FractionStorage.DEFENCE_ENERGY_REWARD[this.data.getValue()];
            text = this.model.lang.format("window.gate.description.defence", energy);
        } else {
            energy = FractionStorage.INVADE_ENERGY_REWARD[this.data.getValue()];
            int needCapturedGate = this.storage.worldConfig.getNeedCapturedGate();
            text = this.model.lang.format("window.gate.description.invade", needCapturedGate, energy);
        }
        if (!avatar.isGateActive()) {
            text = (String)text + "\n\n\u0412\u044b \u043e\u0434\u0435\u0440\u0436\u0430\u043b\u0438 \u0442\u0440\u0438 \u043f\u043e\u0431\u0435\u0434\u044b \u043d\u0430 \u0432\u0440\u0430\u0442\u0430\u0445, \u0432\u0440\u0430\u0442\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0434\u043b\u044f \u0437\u0430\u0445\u0432\u0430\u0442\u0430, \u0430\u0440\u043c\u0438\u044f \u043d\u0435 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043e: " + TimeUtils.shortWithoutYear(avatar.gateBlockTime + TimeUnit.HOURS.toMillis(1L));
        }
        this.decription = new Label((CharSequence)text, descriptionStyle);
        this.decription.setWrap(true);
        this.decription.setAlignment(8);
        this.rightSide.add(this.decription).width(320.0f).expandY().top().padTop(5.0f).row();
        Label.LabelStyle teleportStyle = new Label.LabelStyle();
        teleportStyle.font = GateWindow.assets.getFont().centryGothicBold25;
        teleportStyle.fontColor = Color.valueOf("#D92121");
        this.timerText = new Label((CharSequence)"00:00", teleportStyle);
        this.rightSide.add(this.timerText).expandY().bottom().padBottom(20.0f).row();
        this.teleportBtn = new TextButton(this.model.lang.get("window.gate.invade"), GateWindow.assets.getUi().redButtonStyle);
        this.teleportBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                boolean gateAvail;
                AvatarData avatar = ((GateWindow)GateWindow.this).model.player.selectedAvatar;
                PlanetData planet = GateWindow.this.storage.planet.get(avatar.planetId);
                boolean bl = gateAvail = GateWindow.this.storage.planet.isGatePlanet(planet) && (avatar.level <= planet.maxLevel || planet.maxLevel == 0);
                if (!gateAvail) {
                    WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.gate", "window.gate.info.message", "window.gate.info.answer");
                    WindowManager.getInstance().open(wnd, true);
                    return;
                }
                GateWindow.this.comander.GateActionTeleport(GateWindow.this.data.getId());
                ((GateWindow)GateWindow.this).soundSystem.fx.play("sound/fx/5. Teleport (move to a new planet, enter the game).mp3");
                GateWindow.this.closeHandler();
            }
        });
        this.rightSide.add(this.teleportBtn).bottom().padBottom(10.0f).row();
        Label.LabelStyle occupationStyle = new Label.LabelStyle(GateWindow.assets.getFont().arialBold14, Color.valueOf("#EFD774"));
        this.occupationText = new Label((CharSequence)"", occupationStyle);
        this.rightSide.add(this.occupationText).padBottom(20.0f);
        this.actionBtn = new TextButton(this.model.lang.get("window.gate.capture"), this.getSkin(), "yellow-btn");
        this.actionBtn.setX((this.getWidth() - this.actionBtn.getWidth()) / 2.0f);
        this.actionBtn.setY(15.0f);
        this.actionBtn.getLabel().setColor(Color.valueOf("#3A3631"));
        this.getButtonTable().add(this.actionBtn);
        this.getButtonTable().padBottom(6.0f);
        this.actionBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                boolean gateAvail;
                PlanetData planet = GateWindow.this.storage.planet.get(avatar.planetId);
                boolean bl = gateAvail = GateWindow.this.storage.planet.isGatePlanet(planet) && (avatar.level <= planet.maxLevel || planet.maxLevel == 0);
                if (!gateAvail) {
                    String text = "\u0412\u0430\u0448 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a \u0434\u043b\u044f \u0437\u0430\u0445\u0432\u0430\u0442\u0430 \u044d\u0442\u0438\u0445 \u0432\u0440\u0430\u0442! \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u0439\u0442\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0432\u0440\u0430\u0442\u0430 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u043f\u043b\u0430\u043d\u0435\u0442\u0435.";
                    WarningWindow wnd = new WarningWindow(WarningWindow.Type.INFO, "\u0412\u0440\u0430\u0442\u0430", text, "\u041e\u043a");
                    WindowManager.getInstance().open(wnd, true);
                    return;
                }
                if (GateWindow.this.buildingData != null && GateWindow.this.buildingData.hasAvatar()) {
                    GateWindow.this.comander.GateActionLiberate(GateWindow.this.data.getId());
                    ((GateWindow)GateWindow.this).soundSystem.fx.play("sound/fx/21. Leave portal, mine, digg.mp3");
                } else {
                    GateWindow.this.comander.GateActionUsurp(GateWindow.this.data.getId());
                    ((GateWindow)GateWindow.this).soundSystem.fx.play("sound/fx/18. Capture_a_Portal.mp3");
                }
            }
        });
        this.update();
        this.model.addListener(this, Cmd.BuildingUpdate.getCode());
        this.model.addListener(this, Cmd.PlanetStatus.getCode());
        this.model.addListener(this, Cmd.OccupationStatus.getCode());
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.timerActive) {
            this.timerDelta += delta;
            if (this.timerDelta > 1.0f) {
                this.timerDelta -= 1.0f;
                this.updateTimer();
            }
        }
    }

    public void updateTimer() {
        AvatarData avatar = this.model.player.selectedAvatar;
        long timeout = avatar.getInvasionTimeout();
        long timeLeft = timeout - (this.model.getServerTime() - avatar.lastInvasionTime);
        this.timerText.setText(StringUtils.convertTimeHours((int)(timeLeft /= 1000L)));
        boolean bl = this.timerActive = timeLeft > 0L;
        if (!this.timerActive) {
            this.timerText.setVisible(false);
        }
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        this.update();
    }

    private void update() {
        AvatarData avatarData = this.model.player.selectedAvatar;
        if (this.data.getFactionId() == avatarData.fractionId) {
            this.timerText.setVisible(false);
            this.teleportBtn.setVisible(false);
            this.occupationText.setVisible(false);
        } else {
            boolean canUseGate = avatarData.canUseGate();
            this.occupationText.setText("\u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043b\u0438\u0441\u044c: " + avatarData.fractionStatus.numInvaders + "/8");
            this.teleportBtn.setDisabled(!canUseGate || avatarData.fractionStatus.numInvaders == 8);
            if (canUseGate) {
                this.timerActive = false;
                this.timerText.setVisible(false);
            } else {
                this.timerText.setVisible(true);
                this.updateTimer();
            }
        }
        if (this.buildingData != null && this.buildingData.hasAvatar()) {
            this.setAvatar(this.buildingData.avatar);
            if (this.buildingData.avatar.id == avatarData.id) {
                this.actionBtn.setDisabled(false);
                this.actionBtn.setText(this.model.lang.get("window.gate.liberate"));
            } else {
                this.actionBtn.setDisabled(true);
            }
        } else {
            String goalType = this.data.getFactionId() == avatarData.fractionId ? "defence" : "invide";
            boolean hasQuestActiveGoal = avatarData.hasQuestActiveGoal(goalType);
            this.actionBtn.setDisabled(!hasQuestActiveGoal && !avatarData.isGateActive());
            this.setBuilding();
            this.actionBtn.setText(this.model.lang.get("window.gate.capture"));
        }
    }

    private void setAvatar(AvatarData avatar) {
        this.buildingIcon.remove();
        if (this.avatarSlot != null) {
            this.avatarSlot.remove();
        }
        this.avatarSlot = new AvatarSlotWithButton(avatar);
        this.slotContainer.setActor(this.avatarSlot);
        System.out.println(this.slotContainer.getPrefHeight());
    }

    private void setBuilding() {
        if (this.avatarSlot != null) {
            this.avatarSlot.remove();
        }
        this.slotContainer.setActor(this.buildingIcon);
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }
}

