/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.gift;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.player.PlayerGiftData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.storage.avatar.ArtefactType;
import packet.Static;

public class ActivatedGiftWindow
extends DefaultWindow {
    private PlayerGiftData gift;

    public ActivatedGiftWindow(PlayerGiftData gift) {
        super("\u041f\u043e\u0434\u0430\u0440\u043e\u043a");
        this.gift = gift;
    }

    @Override
    public void openHandler() {
        Stack stack;
        Static.StaticGiftType giftType = this.storage.giftTypes.get(this.gift.giftTypeId);
        String text = "\u0412\u0430\u043c \u043d\u0430\u0447\u0438\u043b\u0435\u043d \u043f\u043e\u0434\u0430\u0440\u043e\u043a, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0437\u0430\u0431\u0440\u0430\u0442\u044c \u0435\u0433\u043e \u043d\u0430 \u043b\u044e\u0431\u043e\u043c \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0435!";
        Label.LabelStyle style = new Label.LabelStyle(ActivatedGiftWindow.assets.getFont().arial16, Color.valueOf("#F0E9CF"));
        Label label = new Label((CharSequence)text, style);
        label.setAlignment(1);
        label.setWrap(true);
        this.getContentTable().add(label).width(300.0f).pad(10.0f).row();
        TextureAtlas atlas = assets.getWindowAtlas();
        TextureAtlas commonAtlas = assets.getCommonAtlas();
        TextureAtlas profileAtlas = (TextureAtlas)assets.get("ui/profile.atlas");
        Table giftTable = new Table();
        giftTable.setBackground(assets.getDrawable(atlas, "content_background"));
        giftTable.defaults().padTop(6.0f).padBottom(6.0f);
        this.getContentTable().add(giftTable).pad(10.0f, 20.0f, 10.0f, 20.0f).growX();
        style = new Label.LabelStyle(ActivatedGiftWindow.assets.getFont().arialBold14, Color.valueOf("EFD774"));
        Array<Object> items = new Array<Object>();
        if (giftType.getCrystals() > 0) {
            stack = new Stack();
            stack.add(new Image(profileAtlas.findRegion("slot")));
            stack.add(new Container<Image>(new Image(commonAtlas.findRegion("crystal_icon"))));
            Table crystal = new Table();
            crystal.add(stack).row();
            crystal.add(new Label((CharSequence)("x" + giftType.getCrystals()), style));
            items.add(crystal);
        }
        if (giftType.getEnergy() > 0) {
            stack = new Stack();
            stack.add(new Image(profileAtlas.findRegion("slot")));
            stack.add(new Container<Image>(new Image(commonAtlas.findRegion("energy_icon"))));
            Table energy = new Table();
            energy.add(stack).row();
            energy.add(new Label((CharSequence)("x" + giftType.getEnergy()), style));
            items.add(energy);
        }
        if (giftType.getTimeWarpTypeId() > 0L) {
            Static.StaticTimeWarpType warpType = this.storage.timeWarp.get(giftType.getTimeWarpTypeId());
            Image image = new Image(profileAtlas.findRegion(warpType.getSacle() < 0 ? "time_war_s" : "time_warp_f"));
            Object timeWarp = new Table();
            ((Table)timeWarp).add(image).row();
            ((Table)timeWarp).add(new Label((CharSequence)"x1", style));
            items.add(timeWarp);
        }
        if (giftType.getArtefactTypeId() > 0L) {
            ArtefactType artefactType = this.storage.artefactType.get(giftType.getArtefactTypeId());
            String iconName = "dead_ray_icon";
            switch (artefactType.code) {
                case "double_power": {
                    iconName = "double_power_icon";
                    break;
                }
                case "dynamic_shield": {
                    iconName = "dynamic_shield_icon";
                    break;
                }
                case "heal": {
                    iconName = "heal_icon";
                }
            }
            Table artefact = new Table();
            artefact.add(new Image(profileAtlas.findRegion(iconName))).row();
            artefact.add(new Label((CharSequence)("x" + giftType.getArtefactCounts()), style));
            items.add(artefact);
        }
        for (int i = 0; i < items.size; ++i) {
            giftTable.add((Actor)items.get(i)).space(6.0f);
        }
    }
}

