/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.gift;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.Model;
import com.tpwar.domain.player.PlayerGiftData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.gift.GiftWindow;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.avatar.ArtefactType;
import packet.Static;

public class GiftSelectWindow
extends DefaultWindow {
    protected static final Assets assets = Assets.getInstance();
    protected final Commander commander = Commander.getInstance();
    protected final Storage storage = Storage.getInstance();
    protected final Model model = Model.getInstance();
    private static final Color[] ROW_COLORS = new Color[]{Color.valueOf("#1A1D22"), Color.valueOf("#24282F")};

    public GiftSelectWindow() {
        super("\u0412\u0430\u0448\u0438 \u043f\u043e\u0434\u0430\u0440\u043a\u0438");
    }

    @Override
    public void openHandler() {
        Array<PlayerGiftData> gifts = this.model.player.gifts;
        Table giftTable = new Table();
        giftTable.defaults().space(6.0f);
        Table container = new Table();
        container.setBackground(assets.getNinePatchDrawable(assets.getWindowAtlas(), "content_background", 6, 6, 6, 6));
        Label.LabelStyle style = new Label.LabelStyle(GiftSelectWindow.assets.getFont().arialBold14, Color.valueOf("#F0E9CF"));
        Label label = new Label((CharSequence)"\u0412\u0430\u043c \u0434\u0430\u0440\u043e\u0432\u0430\u043d\u044b \u043f\u043e\u0434\u0430\u0440\u043a\u0438 \u043e\u0442 \u0444\u0440\u0430\u043a\u0446\u0438\u0438. \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u0430\u0440\u043e\u043a \u0438 \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0435\u0433\u043e", style);
        label.setAlignment(1);
        label.setWrap(true);
        this.getContentTable().add(label).width(250.0f).pad(10.0f).padTop(20.0f).row();
        for (int i = 0; i < gifts.size; ++i) {
            final PlayerGiftData giftData = gifts.get(i);
            Color rowColor = ROW_COLORS[i % ROW_COLORS.length];
            Image background = new Image(assets.getColoredDrawable(1, 1, rowColor));
            Table slot = new Table();
            slot.add(new GiftPanel(giftData)).left();
            Stack stack = new Stack(background, slot);
            stack.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    WindowManager windowManager = WindowManager.getInstance();
                    windowManager.closeCurrentWindow();
                    windowManager.open(new GiftWindow(giftData), true);
                }
            });
            giftTable.add(stack).grow().row();
        }
        ScrollPane scrollPane = new ScrollPane((Actor)giftTable);
        container.add(scrollPane).growX().height(200.0f).top();
        this.getContentTable().add(container).expandY().width(250.0f).center().top().pad(10.0f, 10.0f, 10.0f, 10.0f);
    }

    static class GiftPanel
    extends Table {
        TextureAtlas atlas = assets.getWindowAtlas();
        TextureAtlas commonAtlas = assets.getCommonAtlas();
        TextureAtlas profileAtlas = (TextureAtlas)assets.get("ui/profile.atlas");
        Storage storage = Storage.getInstance();

        public GiftPanel(PlayerGiftData giftData) {
            Stack stack;
            Table giftTable = new Table();
            giftTable.defaults().space(6.0f);
            this.add(giftTable).pad(6.0f).growX();
            Label.LabelStyle style = new Label.LabelStyle(GiftSelectWindow.assets.getFont().arialBold14, Color.valueOf("EFD774"));
            Static.StaticGiftType giftType = this.storage.giftTypes.get(giftData.giftTypeId);
            Array<Object> items = new Array<Object>();
            if (giftType.getCrystals() > 0) {
                stack = new Stack();
                stack.add(new Image(this.profileAtlas.findRegion("slot")));
                stack.add(new Container<Image>(new Image(this.commonAtlas.findRegion("crystal_icon"))));
                Table crystal = new Table();
                crystal.add(stack).row();
                crystal.add(new Label((CharSequence)("x" + giftType.getCrystals()), style));
                items.add(crystal);
            }
            if (giftType.getEnergy() > 0) {
                stack = new Stack();
                stack.add(new Image(this.profileAtlas.findRegion("slot")));
                stack.add(new Container<Image>(new Image(this.commonAtlas.findRegion("energy_icon"))));
                Table energy = new Table();
                energy.add(stack).row();
                energy.add(new Label((CharSequence)("x" + giftType.getEnergy()), style));
                items.add(energy);
            }
            if (giftType.getTimeWarpTypeId() > 0L) {
                Static.StaticTimeWarpType warpType = this.storage.timeWarp.get(giftType.getTimeWarpTypeId());
                Image image = new Image(this.profileAtlas.findRegion(warpType.getSacle() < 0 ? "time_war_s" : "time_warp_f"));
                Object timeWarp = new Table();
                ((Table)timeWarp).add(image).row();
                ((Table)timeWarp).add(new Label((CharSequence)"x1", style));
                items.add(timeWarp);
            }
            if (giftType.getArtefactTypeId() > 0L) {
                ArtefactType artefactType = this.storage.artefactType.get(giftType.getArtefactTypeId());
                String iconName = "dead_ray_icon";
                switch (artefactType.code) {
                    case "double_power": {
                        iconName = "double_power_icon";
                        break;
                    }
                    case "dynamic_shield": {
                        iconName = "dynamic_shield_icon";
                        break;
                    }
                    case "heal": {
                        iconName = "heal_icon";
                    }
                }
                Table artefact = new Table();
                artefact.add(new Image(this.profileAtlas.findRegion(iconName))).row();
                artefact.add(new Label((CharSequence)("x" + giftType.getArtefactCounts()), style));
                items.add(artefact);
            }
            for (int i = 0; i < items.size; ++i) {
                giftTable.add((Actor)items.get(i)).space(6.0f);
            }
        }
    }
}

