/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.gift;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.player.PlayerGiftData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.avatar.ArtefactType;
import packet.Static;

public class GiftWindow
extends GameWindow {
    protected static final Assets assets = Assets.getInstance();
    protected final Commander comander = Commander.getInstance();
    protected final Storage storage = Storage.getInstance();
    protected final Model model = Model.getInstance();
    private final String TEXT_1 = "\u0412\u044b \u0431\u044b\u043b\u0438 \u043e\u0447\u0435\u043d\u044c \u0445\u043e\u0440\u043e\u0448\u0438 \u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0440\u0430\u043a\u0446\u0438\u0438 \u043d\u0430\u0433\u0440\u0430\u0434\u0438\u043b\u043e \u0432\u0430\u0441 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u043c\u0438 \u0432\u0435\u0449\u0430\u043c\u0438:\n";
    private final String TEXT_2 = "\u041f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0435\u043c! \u041d\u0430\u0433\u0440\u0430\u0434\u0430 \u0437\u0430\u0431\u0440\u0430\u043d\u0430, \u0434\u043e\u0441\u0442\u0438\u0433\u0430\u0439\u0442\u0435 \u043d\u043e\u0432\u044b\u0445 \u0432\u0435\u0440\u0448\u0438\u043d \u0432\u043c\u0435\u0441\u0442\u0435 \u0441:\n";
    private final String TEXT_SINGUP_1 = "\u041a\u043e\u043c\u0430\u043d\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u0440\u0438\u0442 \u0432\u0430\u043c \u0438\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u043a\u0440\u0430\u0442\u0438\u0442 \u0432\u0440\u0435\u043c\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u044e\u043d\u0438\u0442\u043e\u0432.";
    private final String TEXT_SINGUP_2 = "\u041f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0435\u043c, \u0438\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d! \u0412\u0440\u0435\u043c\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0438\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044f 24 \u0447\u0430\u0441\u0430.";
    private TextButton actionBtn;
    private PlayerGiftData gift;
    private boolean received;
    private Static.StaticGiftType giftType;

    public GiftWindow(PlayerGiftData gift, boolean received) {
        super("", assets.getDefaultSkin());
        this.gift = gift;
        this.received = received;
    }

    public GiftWindow(PlayerGiftData gift) {
        this(gift, false);
    }

    @Override
    public void openHandler() {
        this.setMovable(false);
        this.setKeepWithinStage(false);
        this.setModal(true);
        this.setClip(false);
        this.setTransform(true);
        this.getTitleLabel().setAlignment(1);
        this.getTitleLabel().setColor(Color.valueOf("#F0E9CF"));
        this.getTitleTable().pack();
        this.padLeft(0.0f);
        this.padRight(0.0f);
        this.padBottom(0.0f);
        this.getContentTable().background(this.getSkin().getDrawable("window_background"));
        Table main = new Table();
        main.defaults().space(20.0f);
        this.getContentTable().add(main).expand().left().bottom().padLeft(20.0f).padRight(20.0f).padTop(10.0f).padBottom(10.0f);
        Image image = new Image(assets.getCommonAtlas().findRegion("gifts_image"));
        image.setY(this.getPrefHeight() - image.getHeight() / 2.0f - 20.0f);
        image.setX((this.getPrefWidth() - image.getWidth()) / 2.0f);
        this.addActor(image);
        Label.LabelStyle style = new Label.LabelStyle(GiftWindow.assets.getFont().arialBold14, Color.WHITE);
        Label label = new Label((CharSequence)"", style);
        label.setAlignment(1);
        label.setWrap(true);
        main.add(label).width(240.0f);
        String text = "";
        text = this.received ? (this.gift.isGiftSignup() ? "\u041f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0435\u043c, \u0438\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d! \u0412\u0440\u0435\u043c\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0438\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044f 24 \u0447\u0430\u0441\u0430." : "\u041f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0435\u043c! \u041d\u0430\u0433\u0440\u0430\u0434\u0430 \u0437\u0430\u0431\u0440\u0430\u043d\u0430, \u0434\u043e\u0441\u0442\u0438\u0433\u0430\u0439\u0442\u0435 \u043d\u043e\u0432\u044b\u0445 \u0432\u0435\u0440\u0448\u0438\u043d \u0432\u043c\u0435\u0441\u0442\u0435 \u0441:\n") : (this.gift.isGiftSignup() ? "\u041a\u043e\u043c\u0430\u043d\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u0440\u0438\u0442 \u0432\u0430\u043c \u0438\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0441\u043e\u043a\u0440\u0430\u0442\u0438\u0442 \u0432\u0440\u0435\u043c\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u044e\u043d\u0438\u0442\u043e\u0432." : "\u0412\u044b \u0431\u044b\u043b\u0438 \u043e\u0447\u0435\u043d\u044c \u0445\u043e\u0440\u043e\u0448\u0438 \u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0440\u0430\u043a\u0446\u0438\u0438 \u043d\u0430\u0433\u0440\u0430\u0434\u0438\u043b\u043e \u0432\u0430\u0441 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u043c\u0438 \u0432\u0435\u0449\u0430\u043c\u0438:\n");
        this.giftType = this.storage.giftTypes.get(this.gift.giftTypeId);
        if (this.gift.isGiftSignup()) {
            label.setText(text);
        } else {
            label.setText(text + "\n" + this.getDescription());
        }
        this.actionBtn = new TextButton(this.received ? "\u0425\u043e\u0440\u043e\u0448\u043e" : "\u0417\u0430\u0431\u0440\u0430\u0442\u044c", this.getSkin(), "yellow-btn");
        this.actionBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!GiftWindow.this.received) {
                    GiftWindow.this.comander.TakeGift(GiftWindow.this.gift.id);
                }
                GiftWindow.this.closeHandler();
            }
        });
        this.getButtonTable().add(this.actionBtn);
        this.getButtonTable().padBottom(6.0f);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (x < 0.0f || x > GiftWindow.this.getWidth() || y < 0.0f || y > GiftWindow.this.getHeight()) {
                    GiftWindow.this.closeHandler();
                }
                return true;
            }
        });
    }

    public String getDescription() {
        StringBuilder res = new StringBuilder();
        if (this.giftType.getEnergy() > 0) {
            res.append("+").append(this.giftType.getEnergy()).append(" \u044d\u043d\u0435\u0440\u0438\u0438\n");
        }
        if (this.giftType.getCrystals() > 0) {
            res.append("+").append(this.giftType.getCrystals()).append(" \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432\n");
        }
        if (this.giftType.getArtefactTypeId() > 0L) {
            ArtefactType artefact = this.storage.artefactType.get(this.giftType.getArtefactTypeId());
            res.append("+").append(this.giftType.getArtefactCounts()).append(" ").append(artefact.name.toLowerCase()).append("\n");
        }
        if (this.giftType.getTimeWarpTypeId() > 0L) {
            res.append("+ \u0438\u0441\u043a\u0440\u0438\u0432\u0438\u0442\u0435\u043b\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438\n");
        }
        return res.toString();
    }

    @Override
    public float getPrefWidth() {
        return 288.0f;
    }

    @Override
    public float getPrefHeight() {
        return 260.0f;
    }
}

