/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.guild;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.guild.TasksBuildingWidget;
import com.tpwar.storage.Storage;
import java.util.ArrayList;
import java.util.List;
import packet.Guild;
import packet.Static;

public class GateTasksWidget
extends Table {
    private final Assets assets = Assets.getInstance();
    private final Storage storage = Storage.getInstance();
    private final Model model = Model.getInstance();
    private AvatarData avatar;
    private TasksBuildingWidget defenceWidget;
    private TasksBuildingWidget invadeWidget;
    private ScrollPane scrollPane;
    private ButtonGroup<ImageTextButton> tabs = new ButtonGroup();

    public GateTasksWidget(List<Guild.TaskBuildingInfoDto> list) {
        this.avatar = this.model.player.selectedAvatar;
        TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/common.atlas");
        ImageTextButton.ImageTextButtonStyle btnStyle = new ImageTextButton.ImageTextButtonStyle();
        btnStyle.up = this.assets.getNinePatchDrawable(atlas, "defence_tab_up", 36, 6, 2, 2);
        btnStyle.checked = this.assets.getNinePatchDrawable(atlas, "defence_tab_down", 36, 6, 2, 2);
        btnStyle.checkedFontColor = Color.valueOf("#F0E9CF");
        btnStyle.checkedFontColor.a = 0.9f;
        btnStyle.font = this.assets.getFont().arialBold14;
        btnStyle.fontColor = Color.valueOf("#F0E9CF");
        btnStyle.fontColor.a = 0.4f;
        ImageTextButton defenceButton = new ImageTextButton("\u041e\u0431\u043e\u0440\u043e\u043d\u0430", btnStyle);
        defenceButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                GateTasksWidget.this.scrollPane.setActor(GateTasksWidget.this.defenceWidget);
            }
        });
        btnStyle = new ImageTextButton.ImageTextButtonStyle(btnStyle);
        btnStyle.up = this.assets.getNinePatchDrawable(atlas, "invade_tab_up", 36, 6, 2, 2);
        btnStyle.checked = this.assets.getNinePatchDrawable(atlas, "invade_tab_down", 36, 6, 2, 2);
        ImageTextButton invadeButton = new ImageTextButton("\u0417\u0430\u0445\u0432\u0430\u0442", btnStyle);
        invadeButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                GateTasksWidget.this.scrollPane.setActor(GateTasksWidget.this.invadeWidget);
            }
        });
        this.tabs.add(defenceButton);
        this.tabs.add(invadeButton);
        ArrayList<Guild.TaskBuildingInfoDto> defenceList = new ArrayList<Guild.TaskBuildingInfoDto>();
        ArrayList<Guild.TaskBuildingInfoDto> invadeList = new ArrayList<Guild.TaskBuildingInfoDto>();
        for (Guild.TaskBuildingInfoDto tbid : list) {
            Static.StaticBuilding building = this.storage.building.get(tbid.getBuildingId());
            if (building.getFactionId() == this.avatar.fractionId) {
                defenceList.add(tbid);
                continue;
            }
            invadeList.add(tbid);
        }
        HorizontalGroup tabsGroup = new HorizontalGroup();
        if (!defenceList.isEmpty()) {
            tabsGroup.addActor(defenceButton);
            this.defenceWidget = new TasksBuildingWidget(defenceList);
        }
        if (!invadeList.isEmpty()) {
            tabsGroup.addActor(invadeButton);
            this.invadeWidget = new TasksBuildingWidget(invadeList);
        }
        this.add(tabsGroup).expandX().left().padLeft(2.0f).row();
        this.scrollPane = new ScrollPane((Actor)(this.defenceWidget != null ? this.defenceWidget : this.invadeWidget));
        Container<ScrollPane> scrollContainer = new Container<ScrollPane>(this.scrollPane);
        scrollContainer.top();
        scrollContainer.setBackground(this.assets.getNinePatchDrawable(atlas, "element_back", 4, 4, 4, 4));
        this.add(scrollContainer).height(320.0f);
    }
}

