/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.guild;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import packet.Guild;
import packet.Static;

public class TaskBuildingLine
extends Table {
    private Assets assets = Assets.getInstance();
    private Storage storage = Storage.getInstance();
    private Model model = Model.getInstance();
    private final Static.StaticBuilding building;

    public TaskBuildingLine(Guild.TaskBuildingInfoDto tbid) {
        this.building = this.storage.building.get(tbid.getBuildingId());
        AvatarData avatar = this.model.player.selectedAvatar;
        Static.StaticZone zone = this.storage.zone.get(this.building.getZoneId());
        PlanetData planet = this.storage.planet.get(zone.getPlanetId());
        Static.StaticBuildingType buildingType = this.storage.buildingType.get(this.building.getBuildingTypeId());
        TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/common.atlas");
        this.setBackground(this.assets.getDrawable(atlas, "task_bg"));
        Image icon = null;
        switch (buildingType.getCode()) {
            case "gate": {
                icon = new Image(this.assets.getDrawable(atlas, "building_gate_icon"));
                this.add(icon);
                break;
            }
            case "mine": {
                icon = new Image(this.assets.getDrawable(atlas, "building_mine_icon"));
                this.add(icon);
                break;
            }
        }
        if (!avatar.checkBuildingAvail(this.building.getId())) {
            icon.setColor(Color.GRAY);
        }
        Color buildingColor = Color.valueOf(this.storage.faction.getColor(this.building.getFactionId()));
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arialBold14, buildingColor);
        Label buildingName = new Label((CharSequence)String.format("%s-%d", planet.name, zone.getPosition()), style);
        buildingName.setAlignment(8);
        this.add(buildingName).expandX().left();
        if (tbid.hasName()) {
            Color fractionColor = Color.valueOf(this.storage.faction.getColor(tbid.getFractionId()));
            style = new Label.LabelStyle(this.assets.getFont().arialBold14, fractionColor);
            Label avatarName = new Label((CharSequence)String.format("%s[%d]", tbid.getName(), tbid.getLevel()), style);
            this.add(avatarName).expandX().right().padRight(6.0f);
        } else if (!avatar.checkBuildingAvail(this.building.getId())) {
            style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.RED);
            Label notAvail = new Label((CharSequence)"\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e", style);
            this.add(notAvail).expandX().right().padRight(6.0f);
        } else {
            style = new Label.LabelStyle(this.assets.getFont().arialBold14, Color.WHITE);
            Label avail = new Label((CharSequence)"\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u043e", style);
            this.add(avail).expandX().right().padRight(6.0f);
        }
    }

    public Static.StaticBuilding getBuilding() {
        return this.building;
    }
}

