/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.guild;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.guild.AvatarTasksWidget;
import com.tpwar.game.windows.guild.GateTasksWidget;
import com.tpwar.game.windows.guild.MineTasksWidget;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.GuildStorage;
import com.tpwar.storage.guild.TaskTypeData;
import java.util.List;
import packet.Guild;
import packet.Static;

public class TaskGuildWindow
extends DefaultWindow {
    private final Storage storage = Storage.getInstance();
    private Guild.GuildTaskList msg;

    public TaskGuildWindow() {
        super("");
    }

    public TaskGuildWindow(Guild.GuildTaskList msg) {
        super("");
        this.msg = msg;
    }

    @Override
    public void openHandler() {
        this.setTitle("\u0413\u0438\u043b\u044c\u0434\u0438\u044f");
        this.getContentTable().defaults().pad(6.0f);
        AvatarData avatar = this.model.player.selectedAvatar;
        if (avatar.hasGuild()) {
            TaskTypeData taskType = this.storage.taskType.get(avatar.getGuild().getTaskTypeId());
            Table table = null;
            switch (taskType.data.getCode()) {
                case "mine": {
                    table = new MineTasksWidget(this.msg.getTasksList());
                    break;
                }
                case "defense": {
                    table = new GateTasksWidget(this.msg.getTasksList());
                    break;
                }
                case "invade": {
                    table = new GateTasksWidget(this.msg.getTasksList());
                    break;
                }
                case "devastation": {
                    table = new GateTasksWidget(this.msg.getTasksList());
                    break;
                }
                case "hunting": {
                    table = new AvatarTasksWidget(this.msg.getAvatarsList());
                    break;
                }
            }
            this.getContentTable().add(table).pad(6.0f).top();
            this.getContentTable().add(this.statistic()).minWidth(200.0f).pad(6.0f).right().top();
        } else {
            this.getContentTable().add(this.statistic()).minWidth(200.0f).pad(14.0f).right().top();
        }
    }

    private Table statistic() {
        Table table = new Table();
        AvatarData avatar = this.model.player.selectedAvatar;
        List<TaskTypeData> taskTypes = this.storage.taskType.getAll();
        TextureAtlas elements = (TextureAtlas)assets.get("entity/entity_elements.atlas");
        Array<TextureRegion> guildTextures = assets.extractRegions(elements, "guild_icon");
        Label.LabelStyle style = new Label.LabelStyle(TaskGuildWindow.assets.getFont().arialBold16, Color.valueOf("#EFD774"));
        Label statisticLabel = new Label((CharSequence)"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430", style);
        table.add(statisticLabel).colspan(3).padBottom(4.0f).row();
        for (TaskTypeData taskType : taskTypes) {
            style = new Label.LabelStyle(TaskGuildWindow.assets.getFont().arialBold14, Color.WHITE);
            Label nameLabel = new Label((CharSequence)this.model.lang.get("task." + taskType.data.getCode()), style);
            table.add(nameLabel).expandX().left();
            Guild.AvatarTaskDto avatarTaskData = avatar.getTask(taskType.data.getId());
            int num = avatarTaskData != null ? avatarTaskData.getScore() : 0;
            Label numLabel = new Label((CharSequence)String.valueOf(num), new Label.LabelStyle(style));
            numLabel.setAlignment(16);
            table.add(numLabel).right().padRight(6.0f);
            Static.StaticGuild guild = this.storage.guild.getGuildByTaskId(taskType.data.getId());
            if (guild != null) {
                Static.StaticGuildRank rank = null;
                if (avatarTaskData != null) {
                    rank = this.storage.guildRanks.getRankByScore(guild.getId(), avatarTaskData.getScore());
                }
                if (rank == null && num < (rank = this.storage.guildRanks.getRank(guild.getId(), 1)).getRequiredNumScoreTask()) {
                    numLabel.getStyle().fontColor = Color.RED;
                    numLabel.setText(num + "/" + rank.getRequiredNumScoreTask());
                }
                int frame = GuildStorage.getGuildRankFrame(rank);
                table.add(new Image(guildTextures.get(frame)));
            }
            table.row();
        }
        return table;
    }
}

