/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.massage;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.utils.Array;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.MessageData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.storage.Storage;

public class DialogWidget
extends Button
implements Comparable<DialogWidget> {
    private String dialogName;
    private long lastTime;
    private AvatarData avatar;
    private MessageData lastMessage;

    public DialogWidget(Assets assets, Storage storage, AvatarData avatar, Array<MessageData> messages) {
        messages.sort();
        this.lastMessage = messages.peek();
        this.avatar = avatar;
        this.dialogName = avatar.name.equalsIgnoreCase(this.lastMessage.sender) ? this.lastMessage.recipient : this.lastMessage.sender;
        this.lastTime = this.lastMessage.timestamp;
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        Button.ButtonStyle style = new Button.ButtonStyle();
        style.checked = assets.getNinePatchDrawable(atlas, "message_dialog_down", 2, 2, 2, 2);
        style.up = assets.getNinePatchDrawable(atlas, "message_dialog_up", 2, 2, 2, 2);
        this.setStyle(style);
        long fractionId = this.findDialogRecipientFraction(messages);
        Color fractionColor = Color.valueOf(storage.faction.getColor(fractionId));
        Label.LabelStyle nameStyle = new Label.LabelStyle(assets.getFont().arialBold14, fractionColor);
        String dialog = this.lastMessage.code.equals("admin_message") ? "Service message" : this.dialogName;
        Label name = new Label((CharSequence)dialog, nameStyle);
        this.add(name).expandX().left().padLeft(6.0f).padRight(6.0f).padTop(2.0f).row();
        Label.LabelStyle dateTimeStyle = new Label.LabelStyle(assets.getFont().arial12, Color.WHITE);
        Label dateTime = new Label((CharSequence)TimeUtils.convertTime(this.lastMessage.timestamp), dateTimeStyle);
        this.add(dateTime).expandX().left().padLeft(6.0f);
    }

    private long findDialogRecipientFraction(Array<MessageData> messages) {
        for (MessageData messageData : messages) {
            if (messageData.sender.equalsIgnoreCase(this.avatar.name)) continue;
            return messageData.fractionId;
        }
        return 0L;
    }

    public String getDialogName() {
        return this.dialogName;
    }

    public String getMessageCode() {
        return this.lastMessage.code;
    }

    @Override
    public int compareTo(DialogWidget arg0) {
        if (arg0.lastTime < this.lastTime) {
            return -1;
        }
        if (arg0.lastTime > this.lastTime) {
            return 1;
        }
        return 0;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(long lastTime) {
        this.lastTime = lastTime;
    }
}

