/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.massage;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.tpwar.domain.avatar.MessageData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.TimeUtils;
import com.tpwar.storage.Storage;
import packet.Static;

public class MessageWidget
extends Table
implements Pool.Poolable {
    private final Storage storage;
    private Label messageLabel;
    private Label dateTime;
    private Container<Label> messageContainer;
    private Array<Drawable> messageBackgrounds = new Array(3);

    public MessageWidget(Assets assets, Storage storage) {
        this.storage = storage;
        Label.LabelStyle messageStyle = new Label.LabelStyle(assets.getFont().arial14, Color.WHITE);
        this.messageLabel = new Label((CharSequence)"", messageStyle);
        this.messageLabel.setWrap(true);
        this.messageLabel.setAlignment(8);
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        this.messageBackgrounds.add(assets.getNinePatchDrawable(atlas, "message_oseon_bg", 4, 4, 4, 4));
        this.messageBackgrounds.add(assets.getNinePatchDrawable(atlas, "message_wayland_bg", 4, 4, 4, 4));
        this.messageBackgrounds.add(assets.getNinePatchDrawable(atlas, "message_bg", 4, 4, 4, 4));
        this.messageContainer = new Container<Label>(this.messageLabel);
        this.messageContainer.minWidth(220.0f);
        this.messageContainer.setTransform(true);
        this.messageContainer.align(8);
        this.add(this.messageContainer).expand().fill().row();
        Label.LabelStyle dateTimeStyle = new Label.LabelStyle(assets.getFont().arial12, Color.valueOf("#F0E9CF"));
        this.dateTime = new Label((CharSequence)"", dateTimeStyle);
        this.add(this.dateTime).expandX().right();
    }

    public void update(MessageData message) {
        this.messageLabel.setText(message.text);
        this.dateTime.setText(TimeUtils.convertTime(message.timestamp));
        Static.StaticFaction fraction = this.storage.faction.get(message.fractionId);
        if (fraction != null) {
            Drawable bg = this.messageBackgrounds.get(this.storage.faction.isOseon(fraction.getCode()) ? 0 : 1);
            this.messageContainer.setBackground(bg);
        } else {
            this.messageContainer.setBackground(this.messageBackgrounds.get(2));
        }
    }

    @Override
    public void reset() {
    }
}

