/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.massage;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.Pool;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.MessageData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.massage.DialogWidget;
import com.tpwar.game.windows.massage.MessageWidget;
import com.tpwar.game.windows.massage.SendMessageWidget;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.Storage;
import io.netty.util.internal.StringUtil;
import packet.Transport;

public class MessageWindow
extends DefaultWindow
implements MessageListener {
    private final Storage storage = Storage.getInstance();
    private final Pool<MessageWidget> messageWidgetPool;
    private Table main = new Table();
    private Array<MessageWidget> messageWidgets = new Array();
    private ArrayMap<String, Array<MessageData>> dialogs = new ArrayMap();
    private OrderedMap<String, DialogWidget> dialogWidgets = new OrderedMap();
    private Table dialogTable = new Table();
    private ButtonGroup<DialogWidget> dialogButtonGroup = new ButtonGroup();
    private Table rigthSide = new Table();
    private Table messageView = new Table();
    private ScrollPane scrollMessages;
    private AvatarData avatar;
    private ScrollPane scrollDialogs;
    private String messageType = "avatar_message";
    private SendMessageWidget sendMessageWidget;
    private String avatarName;

    public MessageWindow() {
        this((String)null);
    }

    public MessageWindow(String avatarName) {
        this.avatarName = avatarName;
        this.messageWidgetPool = new Pool<MessageWidget>(){

            @Override
            protected MessageWidget newObject() {
                return new MessageWidget(assets, MessageWindow.this.storage);
            }
        };
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.messages"));
        this.getContentTable().add(this.main).expand().pad(10.0f, 20.0f, 10.0f, 20.0f);
        this.avatar = this.model.player.selectedAvatar;
        this.dialogButtonGroup.setMinCheckCount(0);
        this.updateDialogs();
        TextureAtlas windowAtlas = (TextureAtlas)assets.get("ui/window.atlas");
        Table leftSide = new Table();
        Label.LabelStyle labelStyle = new Label.LabelStyle(MessageWindow.assets.getFont().arial14, Color.WHITE);
        Label dialogsName = new Label((CharSequence)this.model.lang.get("window.messages.dialogs"), labelStyle);
        leftSide.add(dialogsName).left().top().space(6.0f).row();
        this.scrollDialogs = new ScrollPane((Actor)this.dialogTable);
        Table dialogContainer = new Table();
        dialogContainer.add(this.scrollDialogs).expand().top();
        dialogContainer.setBackground(assets.getNinePatchDrawable(windowAtlas, "content_background", 2, 2, 2, 2));
        dialogContainer.pad(6.0f);
        leftSide.add(dialogContainer).grow().top();
        this.main.add(leftSide).size(156.0f, 360.0f).expand().padRight(10.0f).top();
        this.rigthSide.defaults().space(6.0f);
        this.scrollMessages = new ScrollPane((Actor)this.messageView);
        Container<ScrollPane> messageContainer = new Container<ScrollPane>(this.scrollMessages);
        messageContainer.setBackground(assets.getNinePatchDrawable(windowAtlas, "content_background", 2, 2, 2, 2));
        messageContainer.height(282.0f).width(320.0f).pad(6.0f);
        this.rigthSide.add(messageContainer).expand().bottom().row();
        this.sendMessageWidget = new SendMessageWidget(assets);
        this.sendMessageWidget.setCode(this.messageType);
        this.sendMessageWidget.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MessageWindow.this.updateDialogs();
                MessageWindow.this.updateMessages();
            }
        });
        this.rigthSide.add(this.sendMessageWidget).expandX().fill().left();
        this.main.add(this.rigthSide);
        if (!StringUtil.isNullOrEmpty(this.avatarName)) {
            DialogWidget dialogWidget = (DialogWidget)this.dialogWidgets.get(this.avatarName);
            if (dialogWidget != null) {
                dialogWidget.setChecked(true);
            }
            this.sendMessageWidget.setRecipientName(this.avatarName);
        } else if (this.dialogButtonGroup.getButtons().size > 0) {
            DialogWidget dialogWidget = this.dialogButtonGroup.getButtons().first();
            dialogWidget.setChecked(true);
            if (this.messageType.equals("avatar_message")) {
                this.sendMessageWidget.setCode(dialogWidget.getMessageCode());
            }
            this.sendMessageWidget.setRecipientName(dialogWidget.getDialogName());
        }
        this.updateMessages();
        this.avatar.newMessageNum = 0;
        this.model.addListener(this, Cmd.AvatarMessage.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        this.updateDialogs();
        this.updateMessages();
        this.avatar.newMessageNum = 0;
    }

    private void updateDialogs() {
        this.dialogs.clear();
        this.dialogTable.clear();
        this.dialogButtonGroup.clear();
        Array<MessageData> messages = this.avatar.messages;
        for (MessageData messageData : messages) {
            this.addMessage(messageData);
        }
        for (ObjectMap.Entry<String, Array<MessageData>> entry : this.dialogs) {
            if (this.dialogWidgets.containsKey((String)entry.key)) continue;
            final DialogWidget dialogWidget = new DialogWidget(assets, this.storage, this.avatar, (Array)entry.value);
            dialogWidget.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    MessageWindow.this.updateMessages();
                    MessageWindow.this.sendMessageWidget.setCode(dialogWidget.getMessageCode());
                    MessageWindow.this.sendMessageWidget.setRecipientName(dialogWidget.getDialogName());
                }
            });
            this.dialogWidgets.put((String)entry.key, dialogWidget);
        }
        Array<DialogWidget> temp = this.dialogWidgets.values().toArray();
        temp.sort();
        for (final DialogWidget dialogWidget : temp) {
            this.dialogButtonGroup.add(dialogWidget);
            this.dialogTable.add(dialogWidget).minWidth(140.0f).expand().space(6.0f).top().row();
        }
    }

    private void updateMessages() {
        DialogWidget dialogWidget = this.dialogButtonGroup.getChecked();
        if (dialogWidget == null) {
            return;
        }
        this.dialogButtonGroup.setMinCheckCount(1);
        Array<MessageData> messages = this.dialogs.get(dialogWidget.getDialogName());
        messages.sort();
        this.messageWidgetPool.freeAll(this.messageWidgets);
        this.messageWidgets.clear();
        this.messageView.clear();
        for (MessageData msg : messages) {
            MessageWidget mw = this.messageWidgetPool.obtain();
            mw.update(msg);
            this.messageWidgets.add(mw);
            Cell<MessageWidget> cell = this.messageView.add(mw).expandX().space(8.0f);
            if (this.avatar.name.equalsIgnoreCase(msg.sender)) {
                cell.left();
            } else {
                cell.right();
            }
            cell.row();
        }
        this.scrollMessages.layout();
        this.scrollMessages.setScrollY(this.messageView.getHeight());
    }

    private void addMessage(MessageData msg) {
        if (msg.sender.equalsIgnoreCase(this.avatar.name)) {
            if (!this.dialogs.containsKey(msg.recipient)) {
                this.dialogs.put(msg.recipient, new Array());
            }
            Array<MessageData> temp = this.dialogs.get(msg.recipient);
            temp.add(msg);
            return;
        }
        if (!this.dialogs.containsKey(msg.sender)) {
            this.dialogs.put(msg.sender, new Array());
        }
        Array<MessageData> temp = this.dialogs.get(msg.sender);
        temp.add(msg);
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }
}

