/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.massage;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.CustomSelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.MessageData;
import com.tpwar.game.utils.Assets;
import com.tpwar.net.Commander;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.TaskTypeData;
import io.netty.util.internal.StringUtil;

public class SendMessageWidget
extends Table {
    private Commander commander = Commander.getInstance();
    private Model model = Model.getInstance();
    private TextField inputName;
    private String code;
    private TextField messageInput;
    private CustomSelectBox<SelectBoxType> selectBox;

    public SendMessageWidget(Assets assets) {
        TaskTypeData taskTypeData;
        this.defaults().space(6.0f);
        Table nameTable = new Table();
        Label.LabelStyle labelStyle = new Label.LabelStyle(assets.getFont().arial14, Color.WHITE);
        Label name = new Label((CharSequence)this.model.lang.get("window.messages.to"), labelStyle);
        nameTable.add(name).padRight(6.0f).expandX().left();
        TextureAtlas atlas = assets.getCommonAtlas();
        TextField.TextFieldStyle textInputStyle = new TextField.TextFieldStyle();
        textInputStyle.background = assets.getNinePatchDrawable(atlas, "message_text_bg", 4, 4, 2, 2);
        textInputStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        textInputStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
        textInputStyle.font = assets.getFont().arialBold14;
        textInputStyle.fontColor = Color.WHITE;
        this.inputName = new TextField("", textInputStyle);
        this.inputName.setMessageText(this.model.lang.get("window.messages.name"));
        this.inputName.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                super.keyboardFocusChanged(event, actor, focused);
                if (!focused) {
                    Gdx.input.setOnscreenKeyboardVisible(false);
                }
            }
        });
        nameTable.add(this.inputName).width(120.0f).left().padRight(10.0f);
        SelectBox.SelectBoxStyle selectBoxStyle = new SelectBox.SelectBoxStyle();
        selectBoxStyle.background = assets.getNinePatchDrawable(atlas, "select_box", 4, 28, 2, 2);
        selectBoxStyle.font = assets.getFont().arialBold14;
        selectBoxStyle.fontColor = Color.WHITE;
        selectBoxStyle.scrollStyle = new ScrollPane.ScrollPaneStyle();
        selectBoxStyle.scrollStyle.background = assets.getNinePatchDrawable(atlas, "message_text_bg", 4, 4, 2, 2);
        selectBoxStyle.listStyle = new List.ListStyle(assets.getFont().arialBold14, Color.WHITE, Color.WHITE, assets.getNinePatchDrawable(atlas, "text-field-selection", 2, 1, 1, 1).tint(Color.GRAY));
        this.selectBox = new CustomSelectBox(selectBoxStyle);
        Array<SelectBoxType> items = new Array<SelectBoxType>();
        items.add(new SelectBoxType("avatar_message"));
        final AvatarData avatar = this.model.player.selectedAvatar;
        if (avatar.clanId > 0L) {
            items.add(new SelectBoxType("clan_message"));
        }
        if (avatar.level >= 7 && avatar.hasGuild() && (taskTypeData = Storage.getInstance().taskType.get(avatar.getGuild().getTaskTypeId())).isDevastation()) {
            items.add(new SelectBoxType("defence_message"));
            items.add(new SelectBoxType("invade_message"));
            items.add(new SelectBoxType("devastation_message"));
        }
        if (avatar.isAdmin()) {
            items.add(new SelectBoxType("admin_message"));
        }
        this.selectBox.setItems(items);
        this.selectBox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SelectBoxType selected = SendMessageWidget.this.selectBox.getSelected();
                SendMessageWidget.this.code = selected.messageType;
                switch (selected.messageType) {
                    case "clan_message": {
                        SendMessageWidget.this.inputName.setText(avatar.clanTag);
                        SendMessageWidget.this.inputName.setDisabled(true);
                        break;
                    }
                    case "defence_message": 
                    case "devastation_message": 
                    case "invade_message": 
                    case "admin_message": {
                        SendMessageWidget.this.inputName.setText("");
                        SendMessageWidget.this.inputName.setDisabled(true);
                        break;
                    }
                    default: {
                        SendMessageWidget.this.inputName.setText("");
                        SendMessageWidget.this.inputName.setDisabled(false);
                    }
                }
            }
        });
        nameTable.add(this.selectBox).expandX();
        Table messageTable = new Table();
        this.messageInput = new TextField("", textInputStyle);
        this.messageInput.setMessageText(this.model.lang.get("window.messages.input_message"));
        this.messageInput.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                super.keyboardFocusChanged(event, actor, focused);
                if (!focused) {
                    Gdx.input.setOnscreenKeyboardVisible(false);
                }
            }
        });
        this.messageInput.setTextFieldListener(new TextField.TextFieldListener(){

            @Override
            public void keyTyped(TextField textField, char c) {
                if (c == '\r' || c == '\n') {
                    SendMessageWidget.this.sendMessage();
                }
            }
        });
        messageTable.add(this.messageInput).expandX().fill().padRight(6.0f);
        ImageButton.ImageButtonStyle buttonStyle = new ImageButton.ImageButtonStyle();
        buttonStyle.imageUp = assets.getDrawable(atlas, "message_send_btn_up");
        ImageButton sendBtn = new ImageButton(buttonStyle);
        sendBtn.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SendMessageWidget.this.sendMessage();
            }
        });
        messageTable.add(sendBtn).expandY();
        this.add(nameTable).expandX().left().row();
        this.add(messageTable).expandX().fill().left();
    }

    public void setRecipientName(String name) {
        if ("avatar_message".equals(this.code)) {
            this.inputName.setText(name);
        }
    }

    private void sendMessage() {
        String recipient = this.inputName.getText().trim();
        String text = this.messageInput.getText();
        if (!StringUtil.isNullOrEmpty(text)) {
            if ("avatar_message".equals(this.code)) {
                AvatarData avatar = this.model.player.selectedAvatar;
                if (!recipient.equals(avatar.name)) {
                    MessageData messageData = new MessageData();
                    messageData.code = "avatar_message";
                    messageData.fractionId = avatar.fractionId;
                    messageData.level = avatar.level;
                    messageData.sender = avatar.name;
                    messageData.recipient = recipient;
                    messageData.text = text;
                    messageData.timestamp = this.model.getServerTime();
                    avatar.messages.add(messageData);
                    this.fire(Pools.obtain(ChangeListener.ChangeEvent.class));
                }
            }
            if (this.selectBox.getSelected().messageType.equals(this.code)) {
                this.commander.SendMessage(this.inputName.getText(), this.code, this.messageInput.getText());
                this.messageInput.setText(null);
            }
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        Array<SelectBoxType> items = this.selectBox.getItems();
        for (SelectBoxType type : items) {
            if (!type.messageType.equals(code)) continue;
            this.selectBox.setSelected(type);
            break;
        }
    }

    class SelectBoxType {
        private String messageType;
        private String title;

        public SelectBoxType(String messageType) {
            this.messageType = messageType;
            switch (messageType) {
                case "clan_message": {
                    this.title = SendMessageWidget.this.model.lang.get("window.messages.to_clan");
                    break;
                }
                case "defence_message": {
                    this.title = SendMessageWidget.this.model.lang.get("window.messages.to_defenders");
                    break;
                }
                case "invade_message": {
                    this.title = SendMessageWidget.this.model.lang.get("window.messages.to_invade");
                    break;
                }
                case "devastation_message": {
                    this.title = SendMessageWidget.this.model.lang.get("window.messages.to_devastation");
                    break;
                }
                case "admin_message": {
                    this.title = SendMessageWidget.this.model.lang.get("window.messages.to_all_players");
                    break;
                }
                default: {
                    this.title = SendMessageWidget.this.model.lang.get("window.messages.to_player");
                }
            }
        }

        public String toString() {
            return this.title;
        }

        public String getMessageType() {
            return this.messageType;
        }
    }
}

