/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.NameUtils;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;

public class AvatarInputName
extends Table {
    private Model model = Model.getInstance();
    private Long fractionId;

    public AvatarInputName(TextureAtlas menuAtlas) {
        Assets assets = Assets.getInstance();
        this.defaults().pad(4.0f);
        Label.LabelStyle nameTextStyle = new Label.LabelStyle();
        nameTextStyle.font = assets.getFont().arialBold16;
        Label nameText = new Label((CharSequence)this.model.lang.get("menu.avatar.name"), nameTextStyle);
        this.add(nameText).padRight(4.0f);
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        TextField.TextFieldStyle nameStyle = new TextField.TextFieldStyle();
        nameStyle.cursor = Component.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.BLACK);
        nameStyle.selection = Component.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.BLACK);
        nameStyle.font = assets.getFont().arialBold16;
        nameStyle.fontColor = Color.valueOf("#15344A");
        nameStyle.background = Component.getNinePatchDrawable(atlas, "text-field-background", 1, 1, 1, 1);
        final TextField name = new TextField("", nameStyle);
        name.setMaxLength(9);
        this.add(name).row();
        Label.LabelStyle hintTextStyle = new Label.LabelStyle();
        hintTextStyle.font = assets.getFont().arial12;
        hintTextStyle.fontColor = Color.valueOf("#C6C6C6");
        Label hintText = new Label((CharSequence)this.model.lang.get("avatar.name.hint"), hintTextStyle);
        hintText.setAlignment(1);
        hintText.setWrap(true);
        this.add(hintText).colspan(2).center().width(302.0f).row();
        TextButton.TextButtonStyle buttonStyle = new TextButton.TextButtonStyle();
        buttonStyle.up = new TextureRegionDrawable(menuAtlas.findRegion("registration_btn_up"));
        buttonStyle.over = new TextureRegionDrawable(menuAtlas.findRegion("registration_btn_over"));
        buttonStyle.down = new TextureRegionDrawable(menuAtlas.findRegion("registration_btn_down"));
        buttonStyle.disabled = new TextureRegionDrawable(menuAtlas.findRegion("registration_btn_disable"));
        buttonStyle.font = assets.getFont().arialBold16;
        TextButton button = new TextButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c", buttonStyle);
        button.getLabelCell().padBottom(12.0f);
        this.add(button).colspan(2).center();
        button.addCaptureListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AvatarInputName.this.model.player.availNumAvatars == 5 && AvatarInputName.this.model.player.avatars.size == 5) {
                    AvatarInputName.this.showError(AvatarInputName.this.model.lang.get("menu.avatar.limit"));
                } else if (AvatarInputName.this.model.player.availNumAvatars == AvatarInputName.this.model.player.avatars.size) {
                    AvatarInputName.this.showError(AvatarInputName.this.model.lang.get("menu.avatar.need_slot"));
                } else if (name.getText().length() < 3) {
                    AvatarInputName.this.showError(AvatarInputName.this.model.lang.get("menu.avatar.name_length"));
                } else if (!NameUtils.validateName(name.getText())) {
                    AvatarInputName.this.showError(AvatarInputName.this.model.lang.get("avatar.name.error"));
                } else {
                    Commander.getInstance().CreateAvatar(name.getText(), AvatarInputName.this.fractionId);
                }
            }
        });
    }

    public void showError(String text) {
        WindowManager.getInstance().open(new WarningWindow(WarningWindow.Type.ERROR, this.model.lang.get("window.error"), text, this.model.lang.get("window.confirm.ok")));
    }

    public void setFractionId(Long fractionId) {
        this.fractionId = fractionId;
    }
}

