/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.storage.Storage;

public class AvatarSlot
extends Group {
    private final Assets assets = Assets.getInstance();
    private final Storage storage = Storage.getInstance();
    private Label nameLabel;
    private Label fractionLabel;
    private Label levelLabel;
    private AvatarData avatar;
    private Image expLineBackground;
    private Image expLine;

    public AvatarSlot(TextureAtlas menuAtlas, AvatarData avatar) {
        Image avatarSlotBg = new Image(menuAtlas.findRegion("avatar_slot_bg"));
        this.addActor(avatarSlotBg);
        Image skin = new Image(menuAtlas.findRegion(avatar.getImageName()));
        skin.setPosition((avatarSlotBg.getWidth() - skin.getWidth()) / 2.0f, 90.0f);
        this.addActor(skin);
        this.setSize(avatarSlotBg.getPrefWidth(), avatarSlotBg.getPrefHeight());
        this.expLineBackground = new Image(menuAtlas.findRegion("erge"));
        this.expLine = new Image(menuAtlas.findRegion("dsvs"));
        this.expLineBackground.setPosition((this.getWidth() - this.expLineBackground.getWidth()) / 2.0f, 25.0f);
        this.addActor(this.expLineBackground);
        this.expLine.setPosition(this.expLineBackground.getX(), this.expLineBackground.getY());
        this.addActor(this.expLine);
        this.nameLabel = new Label((CharSequence)"", new Label.LabelStyle(this.assets.getFont().centryGothicBold20, Color.WHITE));
        this.addActor(this.nameLabel);
        this.fractionLabel = new Label((CharSequence)"", new Label.LabelStyle(this.assets.getFont().centryGothic20, Color.WHITE));
        this.addActor(this.fractionLabel);
        this.levelLabel = new Label((CharSequence)"", new Label.LabelStyle(this.assets.getFont().centryGothic15, Color.WHITE));
        this.addActor(this.levelLabel);
        this.setAvatar(avatar);
    }

    public AvatarData getAvatar() {
        return this.avatar;
    }

    public void setAvatar(AvatarData avatar) {
        this.avatar = avatar;
        this.nameLabel.setText(avatar.name);
        this.nameLabel.pack();
        this.nameLabel.setColor(Color.valueOf(this.storage.faction.getColor(avatar.fractionId)));
        this.nameLabel.setY(this.getHeight() - this.nameLabel.getHeight() - 16.0f);
        this.nameLabel.setX((this.getWidth() - this.nameLabel.getWidth()) / 2.0f);
        String fractionName = this.storage.faction.get(avatar.fractionId).getName();
        this.fractionLabel.setText(fractionName);
        this.fractionLabel.pack();
        this.fractionLabel.setPosition((this.getWidth() - this.fractionLabel.getWidth()) / 2.0f, 66.0f);
        this.levelLabel.setText(avatar.level + " " + Model.getInstance().lang.get("menu.level"));
        this.levelLabel.pack();
        this.levelLabel.setPosition((this.getWidth() - this.levelLabel.getWidth()) / 2.0f, 45.0f);
        this.expLine.setWidth(avatar.getProgressLevel() * (this.expLineBackground.getWidth() / 100.0f));
    }
}

