/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Disposable;
import com.tpwar.domain.Model;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.bank.BankWindow;

public class BankBlock
extends Table
implements Disposable {
    private Assets assets = Assets.getInstance();
    private Model model = Model.getInstance();
    private BitmapFont font;
    private Label label;

    public BankBlock(TextureAtlas menuAtlas) {
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = 16;
        parameter.hinting = FreeTypeFontGenerator.Hinting.None;
        parameter.magFilter = Texture.TextureFilter.Linear;
        parameter.minFilter = Texture.TextureFilter.Linear;
        parameter.borderStraight = true;
        parameter.borderColor = Color.GRAY;
        parameter.borderGamma = 2.1f;
        parameter.borderWidth = 0.4f;
        parameter.characters = "Bank\u0411\u0430\u043d\u043a";
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/arialbd.ttf"));
        this.font = generator.generateFont(parameter);
        generator.dispose();
        TextButton.TextButtonStyle tbStyle = new TextButton.TextButtonStyle();
        tbStyle.up = this.assets.getNinePatchDrawable(menuAtlas, "bank_btn_up", 5, 22, 5, 5);
        tbStyle.down = this.assets.getNinePatchDrawable(menuAtlas, "bank_btn_down", 5, 22, 5, 5);
        tbStyle.font = this.font;
        tbStyle.fontColor = Color.WHITE;
        TextButton bankBtn = new TextButton(this.model.lang.get("menu.bank"), tbStyle);
        this.add(bankBtn).width(120.0f).colspan(2).row();
        bankBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WindowManager.getInstance().open(new BankWindow(), true);
            }
        });
        Label.LabelStyle style = new Label.LabelStyle(this.assets.getFont().arial16, Color.WHITE);
        this.label = new Label((CharSequence)"Current balance: ", style);
        this.add(this.label).padRight(4.0f);
        TextureAtlas commonAtlas = (TextureAtlas)this.assets.get("ui/common.atlas");
        Image crystalIcon = new Image(commonAtlas.findRegion("crystal_icon"));
        crystalIcon.setScale(0.8f);
        this.add(crystalIcon).padBottom(2.0f);
        this.update();
    }

    public void update() {
        this.label.setText(this.model.lang.get("menu.balance") + this.model.player.crystals);
        this.pack();
    }

    @Override
    public void dispose() {
        this.font.dispose();
    }
}

