/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.GroupUtil;
import com.tpwar.storage.Storage;
import packet.Static;

public class FractionButton
extends Group {
    private final Static.StaticFaction fraction;

    public FractionButton(TextureAtlas atlas, Static.StaticFaction fraction) {
        this.fraction = fraction;
        Storage storage = Storage.getInstance();
        Assets assets = Assets.getInstance();
        Image bg = new Image(atlas.findRegion(storage.faction.isOseon(fraction.getCode()) ? "reg_fraction_oseon_bg" : "reg_fraction_wayland_bg"));
        bg.setTouchable(Touchable.disabled);
        this.addActor(bg);
        Label.LabelStyle style = new Label.LabelStyle();
        style.font = assets.getFont().centryGothic20;
        style.fontColor = Color.valueOf(storage.faction.getColor(fraction.getId()));
        Label nameFraction = new Label((CharSequence)fraction.getName(), style);
        nameFraction.setX((bg.getWidth() - nameFraction.getWidth()) / 2.0f - 10.0f);
        nameFraction.setY(bg.getHeight() - nameFraction.getHeight() - 18.0f);
        nameFraction.setTouchable(Touchable.disabled);
        this.addActor(nameFraction);
        this.setSize(GroupUtil.getWidth(this), GroupUtil.getHeight(this));
    }

    public Static.StaticFaction getFraction() {
        return this.fraction;
    }
}

