/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.tpwar.Teleports;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.payment.Billing;
import com.tpwar.platform.ApplicationContext;

public class NotificationWindow
extends DefaultWindow {
    private final LocalSettings settings = LocalSettings.getInstance();
    private final Assets assets = Assets.getInstance();
    private final Billing billing = Billing.getInstance();
    private Table leftTable;
    private ImageButton.ImageButtonStyle imageButtonStyle;
    private Label.LabelStyle labelStyle;
    private TextureAtlas mainMenuAtlas;

    public NotificationWindow(TextureAtlas mainMenuAtlas) {
        this.mainMenuAtlas = mainMenuAtlas;
    }

    @Override
    public void openHandler() {
        this.setTitle("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f");
        this.getContentTable().defaults().padLeft(12.0f).padRight(12.0f).padBottom(20.0f).padTop(20.0f);
        this.labelStyle = new Label.LabelStyle();
        this.labelStyle.font = this.assets.getFont().arialBold16;
        this.labelStyle.fontColor = Color.WHITE;
        this.imageButtonStyle = new ImageButton.ImageButtonStyle();
        this.imageButtonStyle.up = new TextureRegionDrawable(this.mainMenuAtlas.findRegion("radio_btn0002"));
        this.imageButtonStyle.checked = new TextureRegionDrawable(this.mainMenuAtlas.findRegion("radio_btn0001"));
        this.leftTable = new Table();
        this.leftTable.defaults().space(10.0f);
        final ApplicationContext context = ((Teleports)Gdx.app.getApplicationListener()).context;
        final ImageButton gameNotification = this.addSettingButton("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0438\u0433\u0440\u044b", "main_notifications", false);
        gameNotification.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                NotificationWindow.this.settings.enable("main_notifications", gameNotification.isChecked());
                if (NotificationWindow.this.settings.get("main_notifications", false)) {
                    context.getPushService().subscribeGameChannel();
                } else {
                    context.getPushService().unsubscribeGameChannel();
                }
            }
        });
        final ImageButton playerNotification = this.addSettingButton("\u041b\u0438\u0447\u043d\u044b\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f", "player_notifications", true);
        playerNotification.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                NotificationWindow.this.settings.enable("player_notifications", playerNotification.isChecked());
                String token = NotificationWindow.this.settings.get("player_notifications", true) ? context.getPushService().getToken() : "";
                NotificationWindow.this.comander.PlayerUpdateToken(token);
            }
        });
        playerNotification.setDisabled(context.getPushService().getToken() == null);
        this.getContentTable().add(this.leftTable).pad(20.0f).padTop(20.0f);
    }

    private ImageButton addSettingButton(String text, String settingName, boolean defaultValue) {
        Label btn = new Label((CharSequence)text, this.labelStyle);
        this.leftTable.add(btn).expandX().left();
        ImageButton button = new ImageButton(this.imageButtonStyle);
        button.setChecked(this.settings.get(settingName, defaultValue));
        this.leftTable.add(button).expandX().row();
        return button;
    }
}

