/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.menu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.Component;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.net.Commander;

public class RemoveAvatarWindow
extends DefaultWindow {
    protected final Color nameColor = Color.valueOf("#F0E9CF");
    protected final Color numColor = Color.valueOf("#EFD774");
    private AvatarData foundAvatar;

    public RemoveAvatarWindow() {
        super(400, 280);
    }

    @Override
    public void openHandler() {
        this.setTitle("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0430");
        Label.LabelStyle labelStyle = new Label.LabelStyle();
        labelStyle.font = RemoveAvatarWindow.assets.getFont().arialBold16;
        labelStyle.fontColor = Color.WHITE;
        labelStyle.font.getData().markupEnabled = true;
        String warning = "[#dd492d]\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435!!!\n \u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0430 \u043f\u043e\u0441\u043b\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f - \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.";
        Label label = new Label((CharSequence)warning, labelStyle);
        label.setWrap(true);
        label.setAlignment(1);
        this.getContentTable().add(label).padLeft(20.0f).padRight(20.0f).width(350.0f).expand().center().row();
        Table avatarInfo = new Table();
        avatarInfo.defaults().space(10.0f);
        this.getContentTable().add(avatarInfo).expandX().padBottom(10.0f).padTop(10.0f).row();
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        TextField.TextFieldStyle nameStyle = new TextField.TextFieldStyle();
        nameStyle.cursor = Component.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.BLACK);
        nameStyle.selection = Component.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.BLACK);
        nameStyle.font = RemoveAvatarWindow.assets.getFont().centryGothicBold20;
        nameStyle.fontColor = Color.valueOf("#15344A");
        nameStyle.background = Component.getNinePatchDrawable(atlas, "text-field-background", 1, 1, 1, 1);
        final TextField name = new TextField("", nameStyle);
        name.setMaxLength(9);
        avatarInfo.add(name);
        Label.LabelStyle numStyle = new Label.LabelStyle(RemoveAvatarWindow.assets.getFont().centryGothicBold20, Color.WHITE);
        final Label level = new Label((CharSequence)"", numStyle);
        avatarInfo.add(level).row();
        labelStyle = new Label.LabelStyle();
        labelStyle.font = RemoveAvatarWindow.assets.getFont().arial16;
        labelStyle.fontColor = Color.WHITE;
        String message = "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0438\u043a \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c.";
        label = new Label((CharSequence)message, labelStyle);
        label.setWrap(true);
        label.setAlignment(1);
        this.getContentTable().add(label).padLeft(20.0f).padRight(20.0f).width(350.0f).expandX().center().row();
        Table price = new Table();
        message = "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c: 50";
        label = new Label((CharSequence)message, labelStyle);
        price.add(label).padRight(4.0f);
        TextureAtlas commonAtlas = (TextureAtlas)assets.get("ui/common.atlas");
        Image crystalIcon = new Image(commonAtlas.findRegion("crystal_icon"));
        crystalIcon.setScale(0.8f);
        price.add(crystalIcon).row();
        this.getContentTable().add(price).padBottom(10.0f).row();
        final TextButton actionButton = new TextButton("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e", RemoveAvatarWindow.assets.getUi().buyButtonStyle);
        actionButton.getLabel().setTouchable(Touchable.disabled);
        actionButton.setDisabled(true);
        actionButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                RemoveAvatarWindow.this.closeHandler();
                if (FinanceManager.checkCrystals(Model.getInstance().player, 50)) {
                    FinanceManager.showConfirmWindow(50, new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            WindowManager.getInstance().closeCurrentWindow();
                            Commander.getInstance().RemoveAvatar(RemoveAvatarWindow.this.foundAvatar.id);
                            ((RemoveAvatarWindow)RemoveAvatarWindow.this).soundSystem.fx.play("sound/fx/28. Buy_crystal.mp3");
                            RemoveAvatarWindow.this.closeHandler();
                        }
                    });
                }
            }
        });
        this.getButtonTable().add(actionButton);
        this.getButtonTable().padBottom(6.0f);
        name.setTextFieldListener(new TextField.TextFieldListener(){

            @Override
            public void keyTyped(TextField textField, char c) {
                RemoveAvatarWindow.this.foundAvatar = null;
                level.setText("");
                for (AvatarData avatar : ((RemoveAvatarWindow)RemoveAvatarWindow.this).model.player.avatars) {
                    if (!avatar.name.equalsIgnoreCase(name.getText().trim())) continue;
                    RemoveAvatarWindow.this.foundAvatar = avatar;
                    level.setText("[" + avatar.level + "]");
                    break;
                }
                actionButton.setDisabled(RemoveAvatarWindow.this.foundAvatar == null);
            }
        });
    }

    private Label addStatField(Table table, String name, Object value, Color textColor, Color color) {
        Label.LabelStyle style = new Label.LabelStyle(RemoveAvatarWindow.assets.getFont().arial14, textColor);
        Label text = new Label((CharSequence)name, style);
        table.add(text).expandX().left();
        Label.LabelStyle numStyle = new Label.LabelStyle(RemoveAvatarWindow.assets.getFont().arialBold14, color);
        Label num = new Label((CharSequence)String.valueOf(value), numStyle);
        num.setAlignment(16);
        table.add(num).expandX().right().row();
        return num;
    }
}

