/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.menu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.tpwar.Teleports;
import com.tpwar.domain.Credentials;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.utils.Component;
import com.tpwar.game.utils.LocalSettings;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.menu.RemoveAvatarWindow;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.payment.Billing;
import com.tpwar.platform.LoginManager;

public class SettingsWindow
extends DefaultWindow {
    private final LocalSettings settings = LocalSettings.getInstance();
    private final Assets assets = Assets.getInstance();
    private final Billing billing = Billing.getInstance();
    private Table leftTable;
    private ImageButton.ImageButtonStyle imageButtonStyle;
    private Label.LabelStyle labelStyle;
    private TextureAtlas mainMenuAtlas;

    public SettingsWindow(TextureAtlas mainMenuAtlas) {
        super("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438");
        this.mainMenuAtlas = mainMenuAtlas;
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.settings"));
        this.getContentTable().defaults().padLeft(12.0f).padRight(12.0f).padBottom(20.0f).padTop(20.0f);
        this.labelStyle = new Label.LabelStyle();
        this.labelStyle.font = this.assets.getFont().arialBold16;
        this.labelStyle.fontColor = Color.WHITE;
        this.imageButtonStyle = new ImageButton.ImageButtonStyle();
        this.imageButtonStyle.up = new TextureRegionDrawable(this.mainMenuAtlas.findRegion("radio_btn0002"));
        this.imageButtonStyle.checked = new TextureRegionDrawable(this.mainMenuAtlas.findRegion("radio_btn0001"));
        this.leftTable = new Table();
        this.leftTable.defaults().space(10.0f);
        this.addSettingButton(this.model.lang.get("window.settings.auto_open_chat"), "chat-auto-open", true);
        this.addSettingButton(this.model.lang.get("window.settings.vibration"), "vibration-in-battle", true);
        this.addSettingButton(this.model.lang.get("window.settings.sound"), "sound", true);
        this.addSettingButton(this.model.lang.get("window.settings.music"), "music", true);
        this.addSettingButton(this.model.lang.get("window.settings.level_icons"), "level_icons", false);
        Table rightTable = new Table();
        rightTable.defaults().space(10.0f).pad(10.0f);
        TextureAtlas atlas = this.assets.getCommonAtlas();
        SelectBox.SelectBoxStyle selectBoxStyle = new SelectBox.SelectBoxStyle();
        selectBoxStyle.background = this.assets.getNinePatchDrawable(atlas, "select_box", 4, 28, 2, 2);
        selectBoxStyle.font = this.assets.getFont().arialBold14;
        selectBoxStyle.fontColor = Color.WHITE;
        selectBoxStyle.scrollStyle = new ScrollPane.ScrollPaneStyle();
        selectBoxStyle.scrollStyle.background = this.assets.getNinePatchDrawable(atlas, "message_text_bg", 4, 4, 2, 2);
        selectBoxStyle.listStyle = new List.ListStyle(this.assets.getFont().arialBold14, Color.WHITE, Color.WHITE, this.assets.getNinePatchDrawable(atlas, "text-field-selection", 2, 1, 1, 1).tint(Color.GRAY));
        final SelectBox selectLanguage = new SelectBox(selectBoxStyle);
        Array<String> items = new Array<String>();
        items.add("ru");
        items.add("en");
        selectLanguage.setItems(items);
        selectLanguage.setSelected(this.settings.getLang());
        selectLanguage.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String selected = (String)selectLanguage.getSelected();
                SettingsWindow.this.settings.save("language", selected);
            }
        });
        Table lang = new Table();
        Label language = new Label((CharSequence)this.model.lang.get("window.settings.language"), this.labelStyle);
        lang.add(language).expandX().left();
        lang.add(selectLanguage);
        rightTable.add(lang).width(180.0f).expand().left().top().row();
        Credentials credentials = ((Teleports)Gdx.app.getApplicationListener()).context.getCredentials();
        if (credentials.getType() == LoginManager.ServiceType.VKONTAKTE || credentials.getType() == LoginManager.ServiceType.VK_ID) {
            Table emailTable = new Table();
            emailTable.setBackground(this.assets.getNinePatchDrawable(atlas, "message_text_bg", 4, 4, 2, 2));
            emailTable.pad(8.0f);
            emailTable.defaults().space(6.0f);
            Label emailLabel = new Label((CharSequence)"Email:", this.labelStyle);
            emailTable.add(emailLabel).padRight(6.0f);
            TextureAtlas commonAtlas = (TextureAtlas)this.assets.get("ui/common.atlas");
            TextField.TextFieldStyle nameStyle = new TextField.TextFieldStyle();
            nameStyle.cursor = Component.getNinePatchDrawable(commonAtlas, "cursor", 1, 1, 1, 1).tint(Color.BLACK);
            nameStyle.selection = Component.getNinePatchDrawable(commonAtlas, "text-field-selection", 1, 1, 1, 1).tint(Color.BLACK);
            nameStyle.font = this.assets.getFont().arialBold16;
            nameStyle.fontColor = Color.valueOf("#15344A");
            nameStyle.background = Component.getNinePatchDrawable(commonAtlas, "text-field-background", 1, 1, 1, 1);
            final TextField email = new TextField(this.model.player.email, nameStyle);
            email.setMaxLength(254);
            emailTable.add(email).width(120.0f).row();
            TextButton emailBtn = new TextButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", this.getSkin(), "yellow-btn");
            emailBtn.getLabel().setTouchable(Touchable.disabled);
            emailBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    Commander.getInstance().PlayerUpdateEmail(email.getText());
                    SettingsWindow.this.closeHandler();
                }
            });
            emailTable.row();
            emailTable.add(emailBtn).colspan(2).padTop(10.0f);
            rightTable.add(emailTable).row();
        }
        TextButton removeAccount = new TextButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442", this.assets.getUi().redButtonStyle);
        removeAccount.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                WarningWindow wnd = new WarningWindow(WarningWindow.Type.WARNING, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442", "\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e", "Ok");
                WindowManager.getInstance().open(wnd, true);
            }
        });
        this.getButtonTable().add(removeAccount);
        this.getButtonTable().padBottom(6.0f);
        if (this.model.player.avatars.size > 0) {
            TextButton.TextButtonStyle tbStyle = new TextButton.TextButtonStyle();
            tbStyle.font = this.assets.getFont().arialBold16;
            tbStyle.fontColor = Color.GRAY;
            TextButton removeAvatarBtn = new TextButton(this.model.lang.get("window.settings.remove_avatar"), tbStyle);
            removeAvatarBtn.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    WindowManager.getInstance().open(new RemoveAvatarWindow(), true);
                }
            });
            rightTable.add(removeAvatarBtn).expandX().center();
        }
        this.getContentTable().add(this.leftTable).pad(20.0f).padTop(20.0f);
        this.getContentTable().add(rightTable).pad(20.0f).padTop(20.0f).fillY();
    }

    private void addSettingButton(String text, final String settingName, final boolean defaultValue) {
        Label vibrationInBattle = new Label((CharSequence)text, this.labelStyle);
        this.leftTable.add(vibrationInBattle).expandX().left();
        final ImageButton button = new ImageButton(this.imageButtonStyle);
        button.setChecked(this.settings.get(settingName, defaultValue));
        button.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SettingsWindow.this.settings.enable(settingName, button.isChecked());
                if (SettingsWindow.this.settings.get("music", defaultValue)) {
                    ((SettingsWindow)SettingsWindow.this).soundSystem.music.resume();
                } else {
                    ((SettingsWindow)SettingsWindow.this).soundSystem.music.pause();
                }
            }
        });
        this.leftTable.add(button).expandX().row();
    }
}

