/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.portal;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.tpwar.game.utils.Assets;

public class PlanetButton
extends ImageButton {
    private final Assets assets = Assets.getInstance();
    private final Image icon;
    private final boolean locked;
    private ShaderProgram shader;

    public PlanetButton(ImageButton.ImageButtonStyle style, Image icon, boolean locked) {
        super(style);
        this.icon = icon;
        this.locked = locked;
        icon.setPosition(33.0f, 36.0f);
        this.addActor(icon);
        if (locked) {
            this.shader = (ShaderProgram)this.assets.get("tint_shader");
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.locked) {
            batch.setShader(this.shader);
            this.shader.setUniformf("u_color", Color.GRAY);
            super.draw(batch, parentAlpha);
            batch.setShader(null);
        } else {
            super.draw(batch, parentAlpha);
        }
    }

    public void setFreactionIcon(Image fractionIcon) {
        fractionIcon.setPosition(2.0f, 4.0f);
        this.addActor(fractionIcon);
    }

    public Image getIcon() {
        return this.icon;
    }
}

