/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.portal;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.portal.PlanetButton;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.net.Commander;
import com.tpwar.sound.SoundSystem;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import java.io.Serializable;
import packet.Static;

public class PlanetWidget
extends Stack {
    private Assets assets = Assets.getInstance();
    private Model model = Model.getInstance();
    private Commander commander = Commander.getInstance();
    private Storage storage = Storage.getInstance();
    private WindowManager windowManager = WindowManager.getInstance();
    private TextureAtlas atlas = (TextureAtlas)this.assets.get("ui/common.atlas");
    private GameWindow window;
    private PlanetData planet;
    private Label titleLabel;
    private PlanetButton planetBtn;
    private Label sizeNameLabel;
    private Label sizeLabel;
    private boolean locked;

    public PlanetWidget(GameWindow window, PlanetData planet) {
        this.window = window;
        this.planet = planet;
        Table planetTable = new Table();
        this.add(planetTable);
        AvatarData avatar = this.model.player.selectedAvatar;
        this.locked = !this.storage.planet.planetIsAvail(planet, avatar);
        Label.LabelStyle titleStyle = new Label.LabelStyle();
        titleStyle.font = this.assets.getFont().arialBold16;
        this.titleLabel = new Label((CharSequence)planet.name, titleStyle);
        planetTable.add(this.titleLabel).colspan(2).center().padBottom(-10.0f).row();
        String iconResourceName = "planet_icon00" + (Serializable)(planet.id < 10L ? "0" + planet.id : Long.valueOf(planet.id));
        TextureRegionDrawable up = new TextureRegionDrawable(this.atlas.findRegion("planet_bg0001"));
        TextureRegionDrawable down = new TextureRegionDrawable(this.atlas.findRegion("planet_bg0002"));
        ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = up;
        btnStyle.down = down;
        this.planetBtn = new PlanetButton(btnStyle, new Image(this.atlas.findRegion(iconResourceName)), this.locked);
        if (planet.factionId > 0L) {
            Static.StaticFaction fraction = this.storage.faction.get(planet.factionId);
            Image fractionIcon = new Image(this.atlas.findRegion(this.storage.faction.isOseon(fraction.getCode()) ? "oseon_icon" : "wayland_icon"));
            this.planetBtn.setFreactionIcon(fractionIcon);
        }
        if (this.locked) {
            Table lock = new Table();
            lock.setBackground(this.assets.getNinePatchDrawable(this.atlas, "blurred_background", 20, 20, 0, 0));
            Label.LabelStyle lockStyle = new Label.LabelStyle();
            lockStyle.font = this.assets.getFont().arialBold14;
            lockStyle.fontColor = Color.FIREBRICK;
            Label lockLabel = new Label((CharSequence)this.model.lang.get("window.portal.planet_not_avail"), lockStyle);
            lock.add(lockLabel).width(80.0f);
            planetTable.setTouchable(Touchable.disabled);
            planetTable.add(new Stack(new Container<PlanetButton>(this.planetBtn), new Container<Table>(lock))).colspan(2).padBottom(-14.0f).row();
        } else {
            this.planetBtn.addListener(new ClickListenerExtension());
            planetTable.add(this.planetBtn).colspan(2).padBottom(-14.0f).row();
        }
        Label.LabelStyle fieldStyle = new Label.LabelStyle();
        fieldStyle.font = this.assets.getFont().arial14;
        this.sizeNameLabel = new Label((CharSequence)this.model.lang.get("window.portal.planet_size"), fieldStyle);
        planetTable.add(this.sizeNameLabel).left().padLeft(18.0f).padBottom(2.0f);
        this.sizeLabel = new Label((CharSequence)Integer.toString(this.storage.zone.getSizePlanet(planet.id)), fieldStyle);
        this.sizeLabel.setAlignment(16);
        planetTable.add(this.sizeLabel).center().row();
        int mineNum = this.storage.building.getNumBuilding(planet.id, "mine");
        int gateNum = this.storage.building.getNumBuilding(planet.id, "gate");
        Label mineNameLabel = new Label((CharSequence)this.model.lang.get("window.portal.mines"), fieldStyle);
        planetTable.add(mineNameLabel).left().padLeft(18.0f).padBottom(2.0f);
        Label mineNumLabel = new Label((CharSequence)Integer.toString(mineNum), fieldStyle);
        mineNumLabel.setAlignment(16);
        planetTable.add(mineNumLabel).center().row();
        Label gateNameLabel = new Label((CharSequence)this.model.lang.get("window.portal.gates"), fieldStyle);
        planetTable.add(gateNameLabel).left().padLeft(18.0f).padBottom(2.0f);
        Label gateNumLabel = new Label((CharSequence)Integer.toString(gateNum), fieldStyle);
        gateNumLabel.setAlignment(16);
        planetTable.add(gateNumLabel).center();
    }

    private final class ClickListenerExtension
    extends ClickListener {
        private ClickListenerExtension() {
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            if (PlanetWidget.this.model.player.selectedAvatar.getNumCreatedUnits() == 0 && !PlanetWidget.this.storage.planet.isHomePlanet(PlanetWidget.this.planet)) {
                WarningWindow wnd = WarningWindow.create(WarningWindow.Type.INFO, "window.portal", "window.portal.need_army", "window.confirm.ok");
                PlanetWidget.this.windowManager.open(wnd, true);
            } else {
                PlanetWidget.this.commander.MoveToPlanet(PlanetWidget.this.planet.id);
                SoundSystem.getInstance().fx.play("sound/fx/5. Teleport (move to a new planet, enter the game).mp3");
                PlanetWidget.this.windowManager.close(PlanetWidget.this.window);
            }
        }
    }
}

