/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.portal;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.portal.PlanetWidget;
import com.tpwar.storage.Storage;
import com.tpwar.storage.planet.PlanetData;
import java.util.List;

public class PortalWindow
extends DefaultWindow {
    private static final Storage storage = Storage.getInstance();
    private Model model = Model.getInstance();
    private ScrollPane scrollPane;
    private Table content;

    public PortalWindow() {
        super(700, 300);
    }

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.portal"));
        this.content = new Table();
        this.content.defaults().space(10.0f);
        AvatarData avatar = this.model.player.selectedAvatar;
        List<PlanetData> planets = PortalWindow.storage.planet.getAllWithSort(avatar);
        for (PlanetData planet : planets) {
            PlanetWidget planetWidget = new PlanetWidget(this, planet);
            this.content.add(planetWidget).expand().left();
        }
        this.scrollPane = new ScrollPane((Actor)this.content);
        this.scrollPane.setScrollX(0.0f);
        this.getContentTable().add(this.scrollPane).expand().left().padLeft(10.0f).padRight(10.0f);
    }
}

