/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.profile;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.google.protobuf.InvalidProtocolBufferException;
import com.tpwar.domain.avatar.ArtefactData;
import com.tpwar.domain.avatar.AvatarData;
import com.tpwar.domain.avatar.AvatarItem;
import com.tpwar.domain.avatar.TimeWarpData;
import com.tpwar.domain.avatar.UnitTechData;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.TimeWarpWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.admin.AdminWindow;
import com.tpwar.game.windows.chroncle.ChronicleWindow;
import com.tpwar.game.windows.clan.ClanInvitationsWindow;
import com.tpwar.game.windows.guild.TaskGuildWindow;
import com.tpwar.game.windows.profile.ChangeNameWindow;
import com.tpwar.game.windows.profile.InventoryWidget;
import com.tpwar.game.windows.warning.WarningWindow;
import com.tpwar.messages.MessageListener;
import com.tpwar.net.Cmd;
import com.tpwar.storage.Storage;
import com.tpwar.storage.guild.GuildStorage;
import com.tpwar.storage.planet.PlanetData;
import java.util.concurrent.TimeUnit;
import packet.Clan;
import packet.Guild;
import packet.Static;
import packet.Transport;

public class AvatarWindow
extends DefaultWindow
implements MessageListener {
    private final Storage storage = Storage.getInstance();
    private final WindowManager windowManager = WindowManager.getInstance();
    private final Color nameColor = Color.valueOf("#F0E9CF");
    private final Color numColor = Color.valueOf("#EFD774");
    private TextureAtlas atlas;
    private AvatarData avatar;
    private Label avatarName;

    @Override
    public void openHandler() {
        this.setTitle(this.model.lang.get("window.profile"));
        this.atlas = (TextureAtlas)assets.get("ui/profile.atlas");
        this.avatar = this.model.player.selectedAvatar;
        this.getContentTable().pad(10.0f);
        this.profile();
        this.separator();
        this.stats();
        this.separator();
        this.inventory();
        this.bottomMenu();
        this.model.addListener(this, Cmd.GuildTaskList.getCode());
        this.model.addListener(this, Cmd.AvatarUpdate.getCode());
        this.model.addListener(this, Cmd.BattleChronicles.getCode());
        this.model.addListener(this, Cmd.ClanInvitationList.getCode());
    }

    @Override
    public void handleMessage(int code, Object data, Transport.Packet msg) throws InvalidProtocolBufferException {
        Cmd cmd = Cmd.Enums.byInt(code);
        switch (cmd) {
            case GuildTaskList: {
                this.windowManager.open(new TaskGuildWindow(Guild.GuildTaskList.parseFrom(msg.getData())), true);
                break;
            }
            case AvatarUpdate: {
                this.avatarName.setText(this.model.player.selectedAvatar.name.toUpperCase());
                break;
            }
            case BattleChronicles: {
                this.windowManager.open(new ChronicleWindow(), true);
                break;
            }
            case ClanInvitationList: {
                this.windowManager.open(new ClanInvitationsWindow(Clan.ClanInvitationList.parseFrom(msg.getData())), true);
                break;
            }
        }
    }

    @Override
    public void closeHandler() {
        this.model.removeListeners(this);
        super.closeHandler();
    }

    private void separator() {
        this.getContentTable().add(new Image(assets.getDrawable(this.atlas, "separator"))).expandY().pad(10.0f);
    }

    private void profile() {
        Static.StaticFaction fraction = this.storage.faction.get(this.avatar.fractionId);
        Label.LabelStyle style = new Label.LabelStyle(AvatarWindow.assets.getFont().arialBold16, this.nameColor);
        this.avatarName = new Label((CharSequence)this.avatar.name.toUpperCase(), style);
        Table table = new Table();
        table.defaults().space(6.0f);
        ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(this.atlas, "change_name_btn_up");
        btnStyle.down = assets.getDrawable(this.atlas, "change_name_btn_up");
        ImageButton changeNameBtn = new ImageButton(btnStyle);
        Table nameTable = new Table();
        nameTable.add(this.avatarName).padRight(6.0f);
        nameTable.add(changeNameBtn);
        nameTable.setTouchable(Touchable.enabled);
        nameTable.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AvatarWindow.this.windowManager.open(new ChangeNameWindow(), true);
            }
        });
        table.add(nameTable).padLeft(14.0f).row();
        String iconName = this.avatar.getImageName() + "_round_icon";
        Image avatarImage = new Image(assets.getDrawable(this.atlas, iconName));
        if (this.avatar.isAdmin()) {
            avatarImage.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    AvatarWindow.this.windowManager.open(new AdminWindow(), true);
                }
            });
        }
        table.add(avatarImage).expandX().row();
        if (this.avatar.clanId > 0L) {
            style = new Label.LabelStyle(AvatarWindow.assets.getFont().arialBold14, this.nameColor);
            Label text = new Label((CharSequence)this.model.lang.get("window.profile.clan"), style);
            text.setAlignment(8);
            Label.LabelStyle numStyle = new Label.LabelStyle(AvatarWindow.assets.getFont().arialBold14, this.numColor);
            Label num = new Label((CharSequence)this.avatar.clanTag, numStyle);
            num.setAlignment(16);
            Table clanTable = new Table();
            clanTable.add(text).expandX().left();
            clanTable.add(num);
            table.add(clanTable).expandX().fillX().row();
        }
        if (this.avatar.hasGuild()) {
            Static.StaticGuild guild = this.storage.guild.getGuild(this.avatar.guildId);
            Static.StaticGuildRank rank = this.storage.guildRanks.get(this.avatar.guildRankId);
            int frame = GuildStorage.getGuildRankFrame(rank);
            TextureAtlas elements = (TextureAtlas)assets.get("entity/entity_elements.atlas");
            TextureRegion guildTexture = assets.extractRegions(elements, "guild_icon").get(frame);
            guildTexture.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Image guilImage = new Image(guildTexture);
            guilImage.setScale(0.9f);
            Label guildLabel = new Label((CharSequence)guild.getName(), new Label.LabelStyle(AvatarWindow.assets.getFont().arialBold14, this.numColor));
            Table guildTable = new Table();
            guildTable.add(guildLabel).expandX().left();
            guildTable.add(guilImage).expandX().right();
            table.add(guildTable).expandX().fillX().row();
        }
        TextureAtlas windowAtlas = assets.getWindowAtlas();
        TextButton.TextButtonStyle changeBtnStyle = new TextButton.TextButtonStyle();
        changeBtnStyle.up = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_up", 4, 4, 4, 4);
        changeBtnStyle.over = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_over", 4, 4, 4, 4);
        changeBtnStyle.down = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_disable", 4, 4, 4, 4);
        changeBtnStyle.disabled = assets.getNinePatchDrawable(windowAtlas, "gray_tab_btn_disable", 4, 4, 4, 4);
        changeBtnStyle.font = AvatarWindow.assets.getFont().arialBold14;
        changeBtnStyle.fontColor = this.nameColor;
        TextButton changeFraction = new TextButton("\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0444\u0440\u0430\u043a\u0446\u0438\u044e", changeBtnStyle);
        changeFraction.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AvatarWindow.this.avatar.clanId > 0L) {
                    AvatarWindow.this.windowManager.open(new WarningWindow(WarningWindow.Type.WARNING, "\u0421\u043c\u0435\u043d\u0430 \u0444\u0440\u0430\u043a\u0446\u0438\u0438", "\u0412\u0430\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u043e\u043a\u0438\u043d\u0443\u0442\u044c \u043a\u043b\u0430\u043d!", "\u041e\u043a"), true);
                    return;
                }
                FinanceManager.showConfirmWindow(((AvatarWindow)AvatarWindow.this).model.lang.format("window.confirm.change_avatar_fraction", 200), new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        if (FinanceManager.checkCrystals(((AvatarWindow)AvatarWindow.this).model.player, 200)) {
                            AvatarWindow.this.comander.ChangeAvatarFraction();
                            AvatarWindow.this.windowManager.closeCurrentWindow();
                            AvatarWindow.this.closeHandler();
                        }
                    }
                });
            }
        });
        table.add(changeFraction).expand().padBottom(10.0f).row();
        this.getContentTable().add(table).width(140.0f).padLeft(6.0f).top();
    }

    private void stats() {
        PlanetData planet = this.storage.planet.get(this.avatar.planetId);
        Static.StaticZone zone = this.storage.zone.get(this.avatar.zoneId);
        Static.StaticLevel nextLevel = this.storage.level.getLevel(this.avatar.level + 1);
        long etnl = nextLevel != null ? nextLevel.getExp() - this.avatar.experience : 0L;
        Color planetColor = planet.factionId > 0L ? Color.valueOf(this.storage.faction.getColor(planet.factionId)) : this.numColor;
        Table table = new Table();
        table.defaults().space(4.0f);
        this.addStatField(table, this.model.lang.get("window.profile.location"), planet.name + "-" + zone.getPosition(), planetColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.level"), this.avatar.level, this.numColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.max_level"), this.avatar.maxLevel, this.numColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.energy"), this.avatar.energy, this.numColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.experiance"), this.avatar.experience, this.numColor, 0);
        this.addStatField(table, this.model.lang.format("window.profile.to_next_level", this.avatar.level + 1), etnl, this.numColor, 8);
        this.addStatField(table, this.model.lang.get("window.profile.wins"), this.avatar.wins, this.numColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.defeats"), this.avatar.defeats, this.numColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.draws"), this.avatar.draws, this.numColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.escapes"), this.avatar.escape, this.numColor, 0);
        this.addStatField(table, this.model.lang.get("window.profile.win_streak"), this.avatar.winsStreak, this.numColor, 0);
        this.getContentTable().add(table).top().padTop(16.0f);
    }

    private void addStatField(Table table, String name, Object value, Color color, int padBottom) {
        Label.LabelStyle style = new Label.LabelStyle(AvatarWindow.assets.getFont().arialBold14, this.nameColor);
        Label text = new Label((CharSequence)name, style);
        table.add(text).width(120.0f).left().padBottom(padBottom);
        Label.LabelStyle numStyle = new Label.LabelStyle(AvatarWindow.assets.getFont().arialBold14, color);
        Label num = new Label((CharSequence)String.valueOf(value), numStyle);
        num.setAlignment(16);
        table.add(num).width(70.0f).right().padBottom(padBottom).row();
    }

    private void inventory() {
        TimeWarpData timeWarpData;
        InventoryWidget inventoryWidget = new InventoryWidget();
        if (this.avatar.unitTechs.size > 0) {
            for (UnitTechData utd : this.avatar.unitTechs) {
                inventoryWidget.addItem(utd);
            }
        }
        if (this.avatar.artefacts.size > 0) {
            for (ArtefactData ad : this.avatar.artefacts) {
                inventoryWidget.addItem(ad);
            }
        }
        if ((timeWarpData = this.avatar.getActiveTimeWarp()) != null) {
            inventoryWidget.addItem(timeWarpData);
        }
        if (this.avatar.hasShield() && this.avatar.shieldData.battleId == 0L) {
            Static.StaticShieldType shieldType = this.storage.shieldType.get(this.avatar.shieldData.typeId);
            if (this.avatar.shieldData.isActive(this.model.getServerTime(), TimeUnit.HOURS.toMillis(shieldType.getTimeAction()))) {
                inventoryWidget.addShield(this.avatar.shieldData);
            }
        }
        if (this.avatar.treasureData != null) {
            inventoryWidget.addItem(this.avatar.treasureData);
        }
        for (AvatarItem item : this.avatar.items.values()) {
            if (this.model.getServerTime() >= item.effectEndTime) continue;
            inventoryWidget.addItem(item);
        }
        inventoryWidget.show();
        ScrollPane scroll = new ScrollPane((Actor)inventoryWidget);
        Label.LabelStyle style = new Label.LabelStyle(AvatarWindow.assets.getFont().arialBold14, this.nameColor);
        Label text = new Label((CharSequence)this.model.lang.get("window.profile.inventory"), style);
        text.setAlignment(8);
        Table table = new Table();
        table.add(text).expandX().left().padBottom(6.0f).row();
        table.add(scroll).padTop(6.0f).left();
        this.getContentTable().add(table).height(250.0f).top().left().padRight(4.0f);
    }

    private void bottomMenu() {
        Label.LabelStyle labelStyle = new Label.LabelStyle(AvatarWindow.assets.getFont().arial12, this.nameColor);
        ImageButton.ImageButtonStyle btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(this.atlas, "chronicle_btn");
        ImageButton chronicleBtn = new ImageButton(btnStyle);
        VerticalGroup btnGroup = new VerticalGroup();
        btnGroup.addActor(chronicleBtn);
        btnGroup.addActor(new Label((CharSequence)this.model.lang.get("window.profile.chronicles_btn"), labelStyle));
        this.getButtonTable().add(btnGroup).expand();
        chronicleBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AvatarWindow.this.comander.GetBattleChronicles();
            }
        });
        btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(this.atlas, "ap_btn");
        ImageButton applicationBtn = new ImageButton(btnStyle);
        btnGroup = new VerticalGroup();
        btnGroup.addActor(applicationBtn);
        btnGroup.addActor(new Label((CharSequence)this.model.lang.get("window.profile.clan_btn"), labelStyle));
        this.getButtonTable().add(btnGroup).expand();
        applicationBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AvatarWindow.this.comander.GetClanInvitationList();
            }
        });
        btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(this.atlas, "tasks_btn");
        ImageButton taskBtn = new ImageButton(btnStyle);
        btnGroup = new VerticalGroup();
        btnGroup.addActor(taskBtn);
        btnGroup.addActor(new Label((CharSequence)this.model.lang.get("window.profile.tasks_btn"), labelStyle));
        this.getButtonTable().add(btnGroup).expand();
        taskBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AvatarWindow.this.avatar.hasGuild()) {
                    AvatarWindow.this.comander.GetGuildTaskList();
                } else {
                    AvatarWindow.this.windowManager.open(new TaskGuildWindow(), true);
                }
            }
        });
        btnStyle = new ImageButton.ImageButtonStyle();
        btnStyle.up = assets.getDrawable(this.atlas, "timewarp_btn");
        ImageButton timeWarpBtn = new ImageButton(btnStyle);
        btnGroup = new VerticalGroup();
        btnGroup.addActor(timeWarpBtn);
        btnGroup.addActor(new Label((CharSequence)this.model.lang.get("window.profile.time_warp_btn"), labelStyle));
        this.getButtonTable().add(btnGroup).expand();
        final Static.StaticTimeWarpType timeWarpType = this.storage.timeWarp.get("acceleration");
        timeWarpBtn.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AvatarWindow.this.windowManager.open(new TimeWarpWindow(timeWarpType, AvatarWindow.this.avatar.id), true);
            }
        });
        this.getButtonTable().padBottom(6.0f);
    }
}

