/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.game.windows.profile;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.tpwar.game.managers.FinanceManager;
import com.tpwar.game.utils.NameUtils;
import com.tpwar.game.windows.DefaultWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.warning.WarningWindow;

public class ChangeNameWindow
extends DefaultWindow {
    private WindowManager windowManager = WindowManager.getInstance();

    public ChangeNameWindow() {
        super("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u0436");
    }

    @Override
    public void openHandler() {
        TextureAtlas atlas = (TextureAtlas)assets.get("ui/common.atlas");
        TextField.TextFieldStyle tfStyle = new TextField.TextFieldStyle();
        tfStyle.cursor = assets.getNinePatchDrawable(atlas, "cursor", 1, 1, 1, 1).tint(Color.WHITE);
        tfStyle.selection = assets.getNinePatchDrawable(atlas, "text-field-selection", 1, 1, 1, 1).tint(Color.GRAY);
        tfStyle.font = ChangeNameWindow.assets.getFont().arialBold16;
        tfStyle.fontColor = Color.WHITE;
        tfStyle.messageFont = ChangeNameWindow.assets.getFont().arial16;
        NinePatchDrawable tfBackground = assets.getNinePatchDrawable(atlas, "text-field-background", 1, 1, 1, 1);
        tfBackground.getPatch().setColor(Color.DARK_GRAY);
        tfStyle.background = tfBackground;
        Label.LabelStyle style = new Label.LabelStyle(ChangeNameWindow.assets.getFont().arial16, Color.valueOf("#F0E9CF"));
        Label inputName = new Label((CharSequence)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f", style);
        this.getContentTable().add(inputName).expandX().pad(6.0f).row();
        final TextField tf = new TextField("", tfStyle);
        tf.setMessageText(this.model.player.selectedAvatar.name);
        this.getContentTable().add(tf).expandX().row();
        tf.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                super.keyboardFocusChanged(event, actor, focused);
                if (!focused) {
                    Gdx.input.setOnscreenKeyboardVisible(false);
                }
            }
        });
        style = new Label.LabelStyle(ChangeNameWindow.assets.getFont().arial14, Color.valueOf("#F0E9CF"));
        Label info = new Label((CharSequence)this.model.lang.get("avatar.name.info"), style);
        info.setWrap(true);
        info.setAlignment(1, 1);
        this.getContentTable().add(info).width(260.0f).pad(6.0f);
        TextButton buyChangeName = new TextButton("\u0421\u043c\u0435\u043d\u0438\u0442\u044c", ChangeNameWindow.assets.getUi().buyButtonStyle);
        buyChangeName.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!NameUtils.validateName(tf.getText())) {
                    String text = ((ChangeNameWindow)ChangeNameWindow.this).model.lang.get("avatar.name.error");
                    ChangeNameWindow.this.windowManager.open(new WarningWindow(WarningWindow.Type.ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430", text, "\u041e\u043a"), true);
                    return;
                }
                if (FinanceManager.checkCrystals(((ChangeNameWindow)ChangeNameWindow.this).model.player, 100)) {
                    FinanceManager.showConfirmWindow(100, new ClickListener(){

                        @Override
                        public void clicked(InputEvent event, float x, float y) {
                            ChangeNameWindow.this.comander.ChangeAvatarName(((ChangeNameWindow)ChangeNameWindow.this).model.player.selectedAvatar.id, tf.getText());
                            ((ChangeNameWindow)ChangeNameWindow.this).soundSystem.fx.play("sound/fx/29. Exchange_crystal_to_energy.mp3");
                            ChangeNameWindow.this.windowManager.closeCurrentWindow();
                            ChangeNameWindow.this.closeHandler();
                        }
                    });
                }
            }
        });
        this.getButtonTable().add(buyChangeName);
        this.getButtonTable().padBottom(6.0f);
    }
}

